/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.shaded.pluginbase.Messages;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.shaded.pluginbase.Managers.DependencyManager;
import xyz.nifeather.morph.shaded.pluginbase.Messages.IDynamicResolver;
import xyz.nifeather.morph.shaded.pluginbase.Messages.MessageStore;
import xyz.nifeather.morph.shaded.pluginbase.XiaMoJavaPlugin;

public class FormattableMessage
implements Comparable<FormattableMessage> {
    private final String key;
    private final String defaultString;
    private final DependencyManager depManager;
    @NotNull
    private String priorityLocale = "";
    private final Map<String, IDynamicResolver> resolvers = new ConcurrentHashMap<String, IDynamicResolver>();
    private MessageStore<?> cachedStore;
    private static final PlainTextComponentSerializer plainTextComponentSerializer = PlainTextComponentSerializer.plainText();

    public FormattableMessage(@NotNull String pluginNameSpace, @NotNull String key, @NotNull String defaultString) {
        this.defaultString = defaultString;
        this.key = key;
        this.depManager = DependencyManager.getInstance(pluginNameSpace);
    }

    public FormattableMessage(@NotNull XiaMoJavaPlugin owningPlugin, @NotNull String key, @NotNull String defaultString) {
        this(owningPlugin.getNamespace(), key, defaultString);
    }

    public FormattableMessage(@NotNull XiaMoJavaPlugin owningPlugin, String value) {
        this(owningPlugin.getNamespace(), "_", value);
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultString() {
        return this.defaultString;
    }

    @NotNull
    public String getPriorityLocale() {
        return this.priorityLocale;
    }

    public boolean hasPriorityLocale() {
        return !this.priorityLocale.isBlank();
    }

    public FormattableMessage preferredLocale(@Nullable String locale) {
        this.priorityLocale = locale == null ? "" : locale;
        return this;
    }

    public FormattableMessage resolveIfNotSet(String key, IDynamicResolver resolver) {
        if (!this.resolvers.containsKey(key)) {
            this.resolvers.put(key, resolver);
        }
        return this;
    }

    public FormattableMessage resolve(String key, IDynamicResolver resolver) {
        this.resolvers.put(key, resolver);
        return this;
    }

    public FormattableMessage resolve(String key, FormattableMessage other) {
        this.resolvers.put(key, other::createComponent);
        return this;
    }

    public FormattableMessage resolve(String key, String plainText) {
        this.resolvers.put(key, locale -> Component.text((String)plainText));
        return this;
    }

    public FormattableMessage resolve(String key, Component component) {
        this.resolvers.put(key, locale -> component);
        return this;
    }

    public FormattableMessage resolve(String key, Object obj) {
        this.resolve(key, obj.toString());
        return this;
    }

    private MessageStore<?> getCachedStore() {
        if (this.cachedStore == null) {
            this.cachedStore = this.depManager.get(MessageStore.class);
        }
        return this.cachedStore;
    }

    public Component createComponent(@Nullable String preferredLocale, MessageStore<?> store) {
        if (store == null) {
            return Component.text((String)this.defaultString);
        }
        String locale = null;
        locale = !this.priorityLocale.isBlank() ? this.priorityLocale : (preferredLocale == null || preferredLocale.isBlank() ? "en_us" : preferredLocale);
        String msg = this.key.equals("_") ? this.defaultString : store.get(this.key, this.defaultString, locale);
        String finalLocale = locale;
        List<TagResolver.Single> resolvers = this.resolvers.entrySet().stream().map(entry -> Placeholder.component((String)((String)entry.getKey()), (ComponentLike)((IDynamicResolver)entry.getValue()).resolve(finalLocale))).toList();
        return MiniMessage.miniMessage().deserialize(msg, TagResolver.resolver(resolvers));
    }

    public Component createComponent(@Nullable String preferredLocale, Class<? extends MessageStore<?>> depClass) {
        return this.createComponent(preferredLocale, this.depManager.get(depClass));
    }

    public Component createComponent(@Nullable String preferredLocale) {
        return this.createComponent(preferredLocale, this.getCachedStore());
    }

    public Component createComponent() {
        return this.createComponent(null, this.getCachedStore());
    }

    public String createString(@Nullable String preferredLocale) {
        return plainTextComponentSerializer.serialize(this.createComponent(preferredLocale));
    }

    public String createString() {
        return this.createString(null);
    }

    public String toString() {
        return "FormattableMessage[key=%s, defaultString=%s]".formatted(this.key, this.defaultString);
    }

    @Override
    public int compareTo(@NotNull FormattableMessage formattableMessage) {
        return this.key.compareTo(formattableMessage.key);
    }
}

