/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.shaded.pluginbase.Utilities;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.shaded.pluginbase.XiaMoJavaPlugin;

public class PluginSoftDependManager
implements Listener {
    private static final Map<String, PluginSoftDependManager> instances = new ConcurrentHashMap<String, PluginSoftDependManager>();
    private final Map<String, Consumer<Plugin>> onEnableStrToConsumerMap = new Object2ObjectOpenHashMap();
    private final Map<String, Consumer<Plugin>> onDisableStrToConsumerMap = new Object2ObjectOpenHashMap();

    public static PluginSoftDependManager getInstance(String namespace) {
        return instances.get(namespace);
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static PluginSoftDependManager getManagerOrCreate(XiaMoJavaPlugin pluginInstance) {
        if (pluginInstance == null) {
            return null;
        }
        PluginSoftDependManager depMgr = instances.get(pluginInstance.getNamespace());
        if (depMgr != null) {
            return depMgr;
        }
        depMgr = new PluginSoftDependManager(pluginInstance);
        return depMgr;
    }

    @Deprecated
    public PluginSoftDependManager(XiaMoJavaPlugin plugin) {
        this.registerPluginInstance(plugin);
    }

    public void registerPluginInstance(XiaMoJavaPlugin plugin) {
        if (instances.containsKey(plugin.getNamespace())) {
            throw new RuntimeException("\u5df2\u7ecf\u6709\u4e00\u4e2aSoftDependManager\u7684\u5b9e\u4f8b\u4e86");
        }
        instances.put(plugin.getNamespace(), this);
    }

    public void unRegisterPluginInstance(XiaMoJavaPlugin plugin) {
        instances.remove(plugin.getNamespace());
    }

    public void setHandle(String id, Consumer<Plugin> onEnable, boolean runOnce) {
        this.setHandle(id, onEnable, null, runOnce);
    }

    public void setHandle(String id, Consumer<Plugin> onEnable) {
        this.setHandle(id, onEnable, null, false);
    }

    public void setHandle(String id, Consumer<Plugin> onEnable, @Nullable Consumer<Plugin> onDisable, boolean runOnce) {
        Plugin plugin;
        Plugin[] plugins;
        Plugin[] pluginArray = plugins = runOnce ? Bukkit.getPluginManager().getPlugins() : new Plugin[]{};
        if (onEnable == null) {
            this.onEnableStrToConsumerMap.remove(id);
        } else {
            this.onEnableStrToConsumerMap.put(id, onEnable);
            if (runOnce && (plugin = (Plugin)Arrays.stream(plugins).filter(p -> p.getName().equals(id)).findFirst().orElse(null)) != null && plugin.isEnabled()) {
                onEnable.accept(plugin);
            }
        }
        if (onDisable == null) {
            this.onDisableStrToConsumerMap.remove(id);
        } else {
            this.onDisableStrToConsumerMap.put(id, onDisable);
            if (runOnce && (plugin = (Plugin)Arrays.stream(plugins).filter(p -> p.getName().equals(id)).findFirst().orElse(null)) != null && !plugin.isEnabled()) {
                onDisable.accept(plugin);
            }
        }
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent e) {
        this.onEnable(e.getPlugin());
    }

    private void onEnable(Plugin plugin) {
        String name = plugin.getName();
        Consumer consumer = this.onEnableStrToConsumerMap.getOrDefault(name, null);
        if (consumer != null) {
            consumer.accept(plugin);
        }
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent e) {
        this.onDisable(e.getPlugin().getName());
    }

    private void onDisable(String name) {
        Consumer consumer = this.onDisableStrToConsumerMap.getOrDefault(name, null);
        if (consumer != null) {
            consumer.accept(null);
        }
    }

    public void clearHandles() {
        this.onDisableStrToConsumerMap.clear();
        this.onEnableStrToConsumerMap.clear();
    }
}

