/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.fmccl.network.commands.S2C.clientrender;

import xyz.nifeather.fmccl.network.BasicServerHandler;
import xyz.nifeather.fmccl.network.commands.S2C.NetheriteS2CCommand;

public class NetheriteS2CRenderMapAddCommand
extends NetheriteS2CCommand<String> {
    private static final NetheriteS2CRenderMapAddCommand invalidPacket = new NetheriteS2CRenderMapAddCommand(-1, null);

    public NetheriteS2CRenderMapAddCommand(Integer playerNetworkId, String mobId) {
        super((T[])new String[]{playerNetworkId.toString(), mobId});
    }

    @Override
    public String getBaseName() {
        return "cra";
    }

    @Override
    public void onCommand(BasicServerHandler<?> handler) {
        handler.onClientMapAddCommand(this);
    }

    public boolean isValid() {
        return this.getArgumentAt(0) != null && this.getArgumentAt(1) != null;
    }

    public int getPlayerNetworkId() {
        if (!this.isValid()) {
            throw new IllegalArgumentException("Trying to get a network id from an invalid packet.");
        }
        return Integer.parseInt(this.getArgumentAt(0, "-1"));
    }

    public String getMobId() {
        if (!this.isValid()) {
            throw new IllegalArgumentException("Trying to get mob id from an invalid packet.");
        }
        return this.getArgumentAt(1, "morph:unknown");
    }

    public static NetheriteS2CRenderMapAddCommand of(Integer networkId, String mobId) {
        return new NetheriteS2CRenderMapAddCommand(networkId, mobId);
    }

    public static NetheriteS2CRenderMapAddCommand of(String arg) {
        String[] argSplit = arg.split(" ");
        if (argSplit.length < 2) {
            return invalidPacket;
        }
        int networkId = -1;
        try {
            networkId = Integer.parseInt(argSplit[0]);
        }
        catch (Throwable t) {
            return invalidPacket;
        }
        return NetheriteS2CRenderMapAddCommand.of(networkId, argSplit[1]);
    }
}

