/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.AnimationPacketListener;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.AttributePacketListener;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.EquipmentPacketListener;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.MetaPacketListener;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.PlayerLookPacketListener;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.ProtocolListener;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.SoundListener;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.SpawnPacketHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;

public class ProtocolHandler
extends MorphPluginObject {
    private final List<ProtocolListener> listeners = new CopyOnWriteArrayList<ProtocolListener>();
    private boolean loadReady;
    private boolean disposed;

    public ProtocolHandler() {
        this.registerRange(new SpawnPacketHandler(), new MetaPacketListener(), new EquipmentPacketListener(), new PlayerLookPacketListener(), new SoundListener(), new AnimationPacketListener(), new AttributePacketListener());
    }

    private void throwIfDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("This instance of ProtocolHandler(%s) is disposed and cannot be used.".formatted(this));
        }
    }

    public boolean contains(ProtocolListener listener) {
        this.throwIfDisposed();
        return this.contains(listener.getIdentifier());
    }

    public boolean contains(String id) {
        this.throwIfDisposed();
        return this.listeners.stream().anyMatch(l -> l.getIdentifier().equalsIgnoreCase(id));
    }

    public boolean register(ProtocolListener listener) {
        this.throwIfDisposed();
        if (this.contains(listener)) {
            return false;
        }
        this.listeners.add(listener);
        if (this.loadReady) {
            try {
                this.registerListenerToPacketManager(listener);
            }
            catch (Throwable t) {
                this.logger.error("Unable to register listener '%s': %s".formatted(listener.getIdentifier(), t.getMessage()));
            }
        }
        return true;
    }

    public boolean registerRange(ProtocolListener ... listeners) {
        this.throwIfDisposed();
        boolean allSuccess = true;
        for (ProtocolListener listener : listeners) {
            allSuccess = this.register(listener) && allSuccess;
        }
        return allSuccess;
    }

    public boolean unregister(ProtocolListener listener) {
        this.throwIfDisposed();
        this.listeners.remove(listener);
        try {
            this.unRegisterListenerFromPacketManager(listener);
        }
        catch (Throwable t) {
            this.logger.error("Error removing packet listener '%s': %s".formatted(listener.getIdentifier(), t.getMessage()));
        }
        return true;
    }

    @Initializer
    private void load() {
        if (this.disposed) {
            return;
        }
        for (ProtocolListener listener : this.listeners) {
            try {
                this.registerListenerToPacketManager(listener);
            }
            catch (Throwable t) {
                this.logger.error("Unable to register listener '%s': %s".formatted(listener.getIdentifier(), t.getMessage()));
            }
        }
        this.loadReady = true;
    }

    private void registerListenerToPacketManager(ProtocolListener listener) {
        PacketEvents.getAPI().getEventManager().registerListener((PacketListener)listener, PacketListenerPriority.NORMAL);
    }

    private void unRegisterListenerFromPacketManager(ProtocolListener listener) {
        this.logger.error("Unregister listener from PacketEvents is not supported by FeatherMorph yet!");
    }

    public boolean disposed() {
        return this.disposed;
    }

    @Override
    public void dispose() {
        for (ProtocolListener listener : this.listeners) {
            try {
                this.unRegisterListenerFromPacketManager(listener);
            }
            catch (Throwable t) {
                this.logger.error("Error removing packet listener %s: %s".formatted(listener.getIdentifier(), t.getMessage()));
            }
        }
        this.disposed = true;
    }
}

