/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.nbt.CompoundTag;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.backends.server.renderer.network.PacketFactory;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.values.AbstractValues;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.values.SingleValue;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.RenderRegistry;
import xyz.nifeather.morph.backends.server.renderer.utilties.WatcherUtils;
import xyz.nifeather.morph.misc.BuildFailedException;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.OffTreeProperties;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;

public abstract class SingleWatcher
extends MorphPluginObject {
    public final UUID bindingUUID;
    private Player bindingPlayer;
    private final EntityType entityType;
    private boolean doingInitialization;
    private final AtomicBoolean syncedOnce = new AtomicBoolean(false);
    protected final Map<String, Object> customRegistry = Collections.synchronizedMap(new Object2ObjectOpenHashMap());
    protected final Map<Integer, Object> registry = new ConcurrentHashMap<Integer, Object>();
    private final Map<Integer, SingleValue<?>> knownValues = new ConcurrentHashMap();
    private final List<Integer> blockedValues = Collections.synchronizedList(new ObjectArrayList());
    private final Map<SingleValue<?>, Object> dirtyValues = Collections.synchronizedMap(new Object2ObjectOpenHashMap());
    private static final Object syncSilentSource = new Object();
    private final Collection<Object> silentRequestSources = Collections.synchronizedList(new ObjectArrayList());
    private final AtomicReference<RenderRegistry> parentRegistryRef = new AtomicReference();
    private boolean disposed;

    protected void initRegistry() {
    }

    public boolean isActive() {
        if (this.bindingPlayer.isOnline()) {
            return true;
        }
        Player player = Bukkit.getPlayer((UUID)this.bindingUUID);
        return player != null;
    }

    public boolean isPlayerOnline() {
        return Bukkit.getOfflinePlayer((UUID)this.bindingUUID).isOnline();
    }

    public Player getBindingPlayer() {
        if (!this.bindingPlayer.isConnected()) {
            if (!Bukkit.getOfflinePlayer((UUID)this.bindingUUID).isOnline()) {
                this.logger.warn("Calling getBindingPlayer for an offline player!");
                Thread.dumpStack();
            } else {
                this.bindingPlayer = Bukkit.getPlayer((UUID)this.bindingUUID);
            }
        }
        return this.bindingPlayer;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public SingleWatcher(Player bindingPlayer, EntityType entityType) {
        this.bindingUUID = bindingPlayer.getUniqueId();
        this.bindingPlayer = bindingPlayer;
        this.entityType = entityType;
        this.doingInitialization = true;
        this.markSilent(this);
        this.initRegistry();
        this.doingInitialization = false;
        this.unmarkSilent(this);
    }

    @Initializer
    private void load() {
        if (!this.syncedOnce.get() && !this.disposed) {
            this.sync();
        }
    }

    public final <X> void writeProperty(SingleProperty<X> property, X value) {
        this.handlePropertyWriteInternal(property, value);
        this.onPropertyWrite(property, value);
    }

    private <X> void handlePropertyWriteInternal(SingleProperty<X> property, X value) {
        if (OffTreeProperties.VIRTUAL_ENTITY_UUID.equals(property)) {
            UUID uuid = (UUID)value;
            this.writeEntry(CustomEntries.SPAWN_UUID, uuid);
        }
    }

    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
    }

    public <X> void writeEntry(CustomEntry<X> entry, X value) {
        this.customRegistry.put(entry.name, value);
        if (this.doingInitialization) {
            return;
        }
        X prev = this.readEntryOrDefault(entry, null);
        this.onEntryWrite(entry, prev, value);
    }

    protected <X> void onEntryWrite(CustomEntry<X> entry, @Nullable X oldVal, @Nullable X newVal) {
    }

    @NotNull
    public <X> X readEntryOrThrow(CustomEntry<X> entry) {
        X val = this.readEntry(entry);
        if (val == null) {
            throw new NullDependencyException("Custom entry '%s' not found in '%s'".formatted(entry, this.getClass().getSimpleName()));
        }
        return val;
    }

    public <X> X readEntryOrDefault(CustomEntry<X> entry, X defaultValue) {
        X val = this.readEntry(entry);
        return val == null ? defaultValue : val;
    }

    @Nullable
    public <X> X readEntry(CustomEntry<X> entry) {
        X val = this.customRegistry.getOrDefault(entry.name, null);
        if (val == null) {
            return null;
        }
        if (entry.type.isInstance(val)) {
            return val;
        }
        this.logger.warn("Find incompatible value '%s' for custom entry '%s'!".formatted(val, entry));
        return null;
    }

    public void resetRegistries() {
        Object2ObjectOpenHashMap registryCopy = new Object2ObjectOpenHashMap(this.registry);
        registryCopy.forEach((id, val) -> {
            SingleValue sv = this.knownValues.getOrDefault(id, null);
            if (sv != null) {
                this.writePersistent(sv, sv.defaultValue());
            }
            this.registry.remove(id);
        });
        Object2ObjectOpenHashMap crCopy = new Object2ObjectOpenHashMap(this.customRegistry);
        crCopy.clear();
    }

    public Map<Integer, SingleValue<?>> getKnownValues() {
        return new Object2ObjectOpenHashMap(this.knownValues);
    }

    public void block(int index) {
        if (!this.blockedValues.contains(index)) {
            this.blockedValues.add(index);
        }
    }

    public void block(SingleValue<?> sv) {
        this.block(sv.index());
    }

    public void unBlock(int index) {
        this.blockedValues.remove((Object)index);
    }

    public void unBlock(SingleValue<?> sv) {
        this.unBlock(sv.index());
    }

    public List<Integer> getBlockedValues() {
        return new ObjectArrayList(this.blockedValues);
    }

    @Nullable
    public SingleValue<?> getSingle(int index) {
        return this.knownValues.getOrDefault(index, null);
    }

    protected boolean register(AbstractValues values) {
        boolean allSuccess = true;
        for (SingleValue<?> value : values.getValues()) {
            allSuccess = this.register(value) && allSuccess;
        }
        return allSuccess;
    }

    protected boolean register(SingleValue<?> singleValue) {
        if (this.knownValues.containsKey(singleValue.index())) {
            return false;
        }
        this.knownValues.put(singleValue.index(), singleValue);
        return true;
    }

    public void remove(SingleValue<?> singleValue) {
        this.registry.remove(singleValue.index());
    }

    public <X> void writeTemp(SingleValue<X> singleValue, @NotNull X value) {
        if (this.registry.containsKey(singleValue.index())) {
            return;
        }
        this.write(singleValue, value, false);
    }

    public <X> void writePersistent(SingleValue<X> singleValue, @NotNull X value) {
        this.write(singleValue, value, true);
    }

    @Nullable
    public <X> SingleValue<X> tryCast(SingleValue<X> external) {
        SingleValue match = this.knownValues.getOrDefault(external.index(), null);
        if (match == null) {
            return null;
        }
        if (match.equals(external)) {
            return match;
        }
        return null;
    }

    private <X> void write(SingleValue<X> singleValue, @NotNull X value, boolean isPersistent) {
        X prevOption;
        X prev;
        if (value == null) {
            throw new IllegalArgumentException("If you wish to remove a SingleValue, use remove()");
        }
        if (!this.knownValues.containsValue(singleValue)) {
            SingleValue<X> cast = this.tryCast(singleValue);
            String message = "Trying to write a SV that doesn't belongs to this Watcher: '%s'. ".formatted(singleValue);
            if (cast == null) {
                throw new IllegalArgumentException(message);
            }
            this.logger.warn(message + "You may want to use 'tryCast(...)' or 'getKnownValues()' to get the correct SV.");
        }
        X x = prev = (prevOption = this.registry.getOrDefault(singleValue.index(), null)) == null ? null : prevOption;
        if (isPersistent) {
            this.registry.put(singleValue.index(), value);
        }
        if (this.doingInitialization) {
            return;
        }
        if (!value.equals(prev)) {
            this.dirtyValues.put(singleValue, value);
        }
        this.onTrackerWrite(singleValue, prev, value);
        if (!this.isSilent() && this.isAlive()) {
            this.sendPacketToAffectedPlayers((PacketWrapper<?>)PacketFactory.buildDiffMetaPacket(this));
        }
    }

    protected <X> void onTrackerWrite(SingleValue<X> single, @Nullable X oldVal, @Nullable X newVal) {
    }

    @NotNull
    public <X> X read(SingleValue<X> singleValue) {
        return this.readOr(singleValue, singleValue.defaultValue());
    }

    public Object read(int index) {
        SingleValue<?> single = this.getSingle(index);
        if (single == null) {
            throw new NullDependencyException("No registry found for index '%s'".formatted(index));
        }
        return this.read(single);
    }

    public Object readOr(int index, Object defaultVal) {
        SingleValue<?> single = this.getSingle(index);
        if (single == null) {
            throw new NullDependencyException("No registry found for index '%s'".formatted(index));
        }
        return this.readOr(single, defaultVal);
    }

    public <X> X readOr(SingleValue<X> singleValue, X defaultVal) {
        X option = this.registry.getOrDefault(singleValue.index(), null);
        if (option == null) {
            return defaultVal;
        }
        return option;
    }

    public boolean isValuePresent(SingleValue<?> singleValue) {
        return this.isValuePresent(singleValue.index());
    }

    public boolean isValuePresent(int index) {
        return this.registry.containsKey(index);
    }

    public Map<Integer, Object> getRegistry() {
        return new Object2ObjectOpenHashMap(this.registry);
    }

    public Map<Integer, Object> getOverlayedRegistry() {
        Map<Integer, Object> map = this.getRegistry();
        this.getDirty().forEach((sv, option) -> map.putIfAbsent(sv.index(), option));
        return map;
    }

    public Map<SingleValue<?>, Object> getDirty() {
        return new Object2ObjectOpenHashMap(this.dirtyValues);
    }

    public void clearDirty() {
        this.dirtyValues.clear();
    }

    public void update() {
    }

    public final void handleEntityMetadataPacket(WrapperPlayServerEntityMetadata packetWrapper) throws ExecutionErrorException {
        List originalData = packetWrapper.getEntityMetadata();
        if (originalData.removeIf(wrapped -> wrapped.getValue().equals("~FEATHERMORPH GENERATED METADATA, THIS MESSAGE SHOULD BE REMOVED, OR SOMETHING MAY GONE WRONG!"))) {
            packetWrapper.setEntityMetadata(originalData);
            return;
        }
        List<EntityData<?>> overrideList = this.rebuildMetadata(originalData);
        overrideList = this.handleEntityMetadata((List<EntityData<?>>)ImmutableList.copyOf((Collection)originalData), overrideList);
        packetWrapper.setEntityMetadata(new ArrayList(overrideList));
    }

    private List<EntityData<?>> rebuildMetadata(List<EntityData<?>> originalData) throws ExecutionErrorException {
        ObjectArrayList overrideList = new ObjectArrayList();
        for (EntityData<?> raw : originalData) {
            int index = raw.getIndex();
            if (this.blockedValues.contains(index)) continue;
            SingleValue<?> sv = this.getSingle(index);
            if (sv == null) {
                throw ExecutionErrorException.forMethod("handleEntityMetadata").withMessage("Index %s not found for watcher of type %s(%s)".formatted(index, this.entityType, this.getClass().getSimpleName())).create();
            }
            if (!raw.getType().equals(sv.type())) continue;
            Object value = this.readOr(sv, null);
            if (value != null) {
                overrideList.add(new EntityData(sv.index(), sv.type(), value));
                continue;
            }
            overrideList.add(raw);
        }
        return overrideList;
    }

    protected List<EntityData<?>> handleEntityMetadata(@Unmodifiable List<EntityData<?>> originalData, List<EntityData<?>> currentData) throws ExecutionErrorException {
        return currentData;
    }

    public void sync() {
        this.markSilent(syncSilentSource);
        this.syncedOnce.set(true);
        this.dirtyValues.clear();
        try {
            this.doSync();
        }
        catch (Throwable t) {
            this.logger.warn("Error occurred while syncing watcher", t);
        }
        this.unmarkSilent(syncSilentSource);
    }

    protected void doSync() {
    }

    public void writeToCompound(CompoundTag nbt) {
    }

    public void markSilent(Object source) {
        this.silentRequestSources.add(source);
    }

    public void unmarkSilent(Object source) {
        if (this.silentRequestSources.isEmpty()) {
            return;
        }
        this.silentRequestSources.remove(source);
    }

    public boolean isSilent() {
        return !this.silentRequestSources.isEmpty();
    }

    public void setParentRegistry(RenderRegistry renderRegistry) {
        this.parentRegistryRef.set(renderRegistry);
    }

    public boolean isAlive() {
        return this.parentRegistryRef.get() != null;
    }

    protected List<Player> getAffectedPlayers(Player sourcePlayer) {
        return WatcherUtils.getAffectedPlayers(sourcePlayer);
    }

    protected void sendPacketToAffectedPlayers(PacketWrapper<?> packet) {
        if (this.isSilent()) {
            this.logger.warn("Not sending packets: Sending packets while we should be silent?!");
            Thread.dumpStack();
            return;
        }
        if (!this.isAlive()) {
            this.logger.warn("Not sending packets: Sending packets while the watcher isn't alive!");
            Thread.dumpStack();
            return;
        }
        List<Player> players = this.getAffectedPlayers(this.getBindingPlayer());
        PlayerManager protocol = PacketEvents.getAPI().getPlayerManager();
        players.forEach(p -> protocol.sendPacket(p, packet));
    }

    public abstract List<PacketWrapper<?>> buildSpawnPackets() throws BuildFailedException;

    public boolean disposed() {
        return this.disposed;
    }

    @Override
    public final void dispose() {
        if (this.disposed) {
            throw new RuntimeException("Already disposed!");
        }
        this.disposed = true;
        try {
            this.onDispose();
        }
        catch (Throwable t) {
            this.logger.warn("Error occurred while disposing", t);
        }
    }

    protected void onDispose() {
    }
}

