/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import com.github.retrooper.packetevents.protocol.entity.cat.CatVariant;
import com.github.retrooper.packetevents.protocol.entity.cat.CatVariants;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import org.bukkit.DyeColor;
import org.bukkit.entity.Cat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.TameableAnimalWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.CatProperties;
import xyz.nifeather.morph.utilities.Uuids;

public class CatWatcher
extends TameableAnimalWatcher {
    public CatWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.CAT);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.CAT);
    }

    private CatVariant getCatVariant(String id) {
        return Objects.requireNonNull((CatVariant)CatVariants.getRegistry().getByName(id), "No cat variant for id: " + id);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        CatProperties properties = DisguiseProperties.INSTANCE.getOrThrow(CatProperties.class);
        if (property.equals(properties.CAT_VARIANT)) {
            Cat.Type variant = (Cat.Type)value;
            this.writePersistent(ValueIndex.CAT.CAT_VARIANT, this.getCatVariant(variant.key().asString()));
        } else if (property.equals(properties.OWNER)) {
            UUID uuid2 = (UUID)value;
            if (Uuids.NIL_UUID.equals(uuid2)) {
                uuid2 = null;
            }
            this.writePersistent(ValueIndex.CAT.OWNER, Optional.ofNullable(uuid2));
            this.writeTamed(uuid2 != null && !Uuids.NIL_UUID.equals(uuid2));
        } else if (property.equals(properties.COLLAR_COLOR)) {
            DyeColor dyeColor = (DyeColor)value;
            this.writePersistent(ValueIndex.CAT.COLLAR_COLOR, Integer.valueOf(dyeColor.getWoolData()));
            this.readOr(ValueIndex.CAT.OWNER, Optional.empty()).ifPresentOrElse(uuid -> {}, () -> this.writeProperty(properties.OWNER, UUID.randomUUID()));
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    protected <X> void onEntryWrite(CustomEntry<X> entry, X oldVal, X newVal) {
        super.onEntryWrite(entry, oldVal, newVal);
        if (entry.equals(CustomEntries.ANIMATION)) {
            String animId;
            switch (animId = newVal.toString()) {
                case "lay_start": {
                    this.writePersistent(ValueIndex.CAT.IS_LYING, true);
                    break;
                }
                case "sit": {
                    this.writePersistent(ValueIndex.CAT.TAMEABLE_FLAGS, (byte)1);
                    break;
                }
                case "standup": 
                case "reset": {
                    if (this.readOr(ValueIndex.CAT.IS_LYING, false).booleanValue()) {
                        this.writePersistent(ValueIndex.CAT.IS_LYING, false);
                    }
                    if ((this.readOr(ValueIndex.CAT.TAMEABLE_FLAGS, (byte)0) & 1) == 0) break;
                    this.writePersistent(ValueIndex.CAT.TAMEABLE_FLAGS, (byte)0);
                }
            }
        }
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        super.writeToCompound(nbt);
        String variant = this.read(ValueIndex.CAT.CAT_VARIANT).getName().toString();
        nbt.putString("variant", variant);
        Integer collarColor = this.read(ValueIndex.CAT.COLLAR_COLOR);
        nbt.putInt("CollarColor", collarColor.intValue());
    }
}

