/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;

public class PufferfishWatcher
extends LivingEntityWatcher {
    public PufferfishWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.PUFFERFISH);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.PUFFERFISH);
    }

    @Override
    protected <X> void onEntryWrite(CustomEntry<X> entry, X oldVal, X newVal) {
        super.onEntryWrite(entry, oldVal, newVal);
        if (entry.equals(CustomEntries.ANIMATION)) {
            String animId = newVal.toString();
            World world = this.getBindingPlayer().getWorld();
            Integer lastState = this.readOr(ValueIndex.PUFFERFISH.PUFF_STATE, 0);
            switch (animId) {
                case "inflate": {
                    this.writePersistent(ValueIndex.PUFFERFISH.PUFF_STATE, 2);
                    if (lastState == 2) break;
                    world.playSound(this.getBindingPlayer().getLocation(), Sound.ENTITY_PUFFER_FISH_BLOW_UP, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "deflate": {
                    this.writePersistent(ValueIndex.PUFFERFISH.PUFF_STATE, 0);
                    if (lastState == 0) break;
                    world.playSound(this.getBindingPlayer().getLocation(), Sound.ENTITY_PUFFER_FISH_BLOW_OUT, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "reset": {
                    this.writePersistent(ValueIndex.PUFFERFISH.PUFF_STATE, 0);
                }
            }
        }
    }
}

