/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.listeners;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import java.util.List;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.ProtocolListener;
import xyz.nifeather.morph.backends.server.renderer.network.registries.RenderRegistry;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.utilities.NmsUtils;

public class AttributePacketListener
extends ProtocolListener {
    @Resolved(shouldSolveImmediately=true)
    private RenderRegistry registry;

    @Override
    public String getIdentifier() {
        return "attribute_packet_listener";
    }

    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() != PacketType.Play.Server.UPDATE_ATTRIBUTES) {
            return;
        }
        WrapperPlayServerUpdateAttributes wrapper = new WrapperPlayServerUpdateAttributes(event);
        Player sourcePlayer = this.getPlayerFrom(wrapper.getEntityId());
        if (sourcePlayer == null) {
            return;
        }
        SingleWatcher watcher = this.registry.getWatcher(sourcePlayer.getUniqueId());
        if (watcher == null) {
            return;
        }
        List<String> syncableAttributes = NmsUtils.getSyncableAttributeListFor(watcher.getEntityType());
        List properties = wrapper.getProperties();
        properties.removeIf(property -> {
            String id = property.getAttribute().getName().toString();
            return syncableAttributes.stream().noneMatch(syncable -> syncable.equals(id));
        });
        if (properties.isEmpty()) {
            event.setCancelled(true);
        }
        super.onPacketSend(event);
    }
}

