/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.utilties;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameType;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.misc.NmsRecord;

public class WatcherUtils {
    public static CompoundTag buildCompoundFromWatcher(SingleWatcher watcher) {
        CompoundTag tag = new CompoundTag();
        watcher.writeToCompound(tag);
        return tag;
    }

    public static List<Player> getAffectedPlayers(@NotNull Player sourcePlayer) {
        List players = sourcePlayer.getWorld().getPlayers();
        players.remove(sourcePlayer);
        NmsRecord nmsRec = NmsRecord.of(sourcePlayer);
        if (nmsRec.nmsPlayer().gameMode.getGameModeForPlayer() == GameType.SPECTATOR) {
            players.removeIf(bukkitPlayer -> NmsRecord.ofPlayer((Player)bukkitPlayer).gameMode.getGameModeForPlayer() != GameType.SPECTATOR);
        }
        ServerLevel nmsWorld = nmsRec.nmsWorld();
        int tracking = nmsWorld.spigotConfig.playerTrackingRange + 1;
        Location sourceLocation = sourcePlayer.getLocation();
        players.removeIf(p -> sourceLocation.distance(p.getLocation()) > (double)tracking);
        return players;
    }
}

