/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.events.mirror.impl;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.events.mirror.ExecutorHub;
import xyz.nifeather.morph.events.mirror.impl.AbstractExecutor;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSneakingCommand;
import xyz.nifeather.morph.storage.mirrorlogging.OperationType;
import xyz.nifeather.morph.utilities.ItemUtils;

public abstract class ChainedExecutor
extends AbstractExecutor {
    protected final ThreadLocal<List<Player>> currentSimulateChain = ThreadLocal.withInitial(ArrayList::new);

    public ChainedExecutor(ExecutorHub executorHub) {
        super(executorHub);
    }

    protected boolean isInChain(Player source) {
        List<Player> list = this.currentSimulateChain.get();
        return list != null && list.contains(source);
    }

    protected boolean isLastInChain(Player player) {
        List<Player> list = this.currentSimulateChain.get();
        return list != null && list.indexOf(player) + 1 == list.size();
    }

    protected void runIfChainable(Player source, Consumer<Player> chainConsumer) {
        List<Player> currentChain = this.currentSimulateChain.get();
        if (currentChain == null) {
            return;
        }
        if (currentChain.contains(source)) {
            return;
        }
        List<Player> chain = this.buildSimulateChain(source);
        this.currentSimulateChain.set(chain);
        Player first = chain.getFirst();
        chain.forEach(pl -> {
            if (!Objects.equals(pl, first)) {
                chainConsumer.accept((Player)pl);
            }
        });
        currentChain.clear();
        this.currentSimulateChain.remove();
    }

    @Nullable
    protected abstract Player findNextControllablePlayerFrom(Player var1, List<Player> var2);

    protected List<Player> buildSimulateChain(Player source) {
        Player next;
        ObjectArrayList chain = new ObjectArrayList();
        chain.add(source);
        Player current = source;
        while (current != null && !chain.contains(next = this.findNextControllablePlayerFrom(current, (List<Player>)chain)) && next != null) {
            chain.add(next);
            current = next;
        }
        return chain;
    }

    @Override
    public void onSneak(Player source, boolean sneaking) {
        this.applyToNearByMannequin(source, mannequin -> mannequin.setPose(sneaking ? Pose.SNEAKING : Pose.STANDING));
        this.runIfChainable(source, p -> {
            p.setSneaking(sneaking);
            this.clientHandler().sendCommand((Player)p, (AbstractS2CCommand<?>)new S2CSetSneakingCommand(sneaking));
            this.logOperation(source, (Player)p, OperationType.ToggleSneak);
        });
    }

    protected void applyToNearByMannequin(Player player, Consumer<Mannequin> consumer) {
        if (!player.hasPermission("feathermorph.mirror.mannequin")) {
            return;
        }
        DisguiseState state = this.morphManager().getDisguiseStateFor(player);
        if (state == null) {
            return;
        }
        int distance = Math.max(this.executorHub.getControlDistance(), 5);
        Entity entity = player.getTargetEntity(distance);
        if (entity instanceof Mannequin) {
            Mannequin mannequin = (Mannequin)entity;
            consumer.accept(mannequin);
        }
    }

    @Override
    public void onSwapHand(Player player) {
        this.runIfChainable(player, targetPlayer -> {
            EntityEquipment equipment = targetPlayer.getEquipment();
            ItemStack mainHandItem = equipment.getItemInMainHand();
            ItemStack offhandItem = equipment.getItemInOffHand();
            equipment.setItemInMainHand(offhandItem);
            equipment.setItemInOffHand(mainHandItem);
            this.logOperation(player, (Player)targetPlayer, OperationType.SwapHand);
        });
    }

    @Override
    public void onHotbarChange(Player player, int slot) {
        this.runIfChainable(player, targetPlayer -> {
            targetPlayer.getInventory().setHeldItemSlot(slot);
            this.logOperation(player, (Player)targetPlayer, OperationType.HotbarChange);
        });
    }

    @Override
    public void onStopUsingItem(Player player, ItemStack itemStack) {
        Material ourHandItem = itemStack.getType();
        this.runIfChainable(player, targetPlayer -> {
            ServerPlayer nmsPlayer = NmsRecord.ofPlayer(targetPlayer);
            if (nmsPlayer.isUsingItem() && ItemUtils.isContinuousUsable(ourHandItem) && nmsPlayer.getUseItem().getBukkitStack().getType() == ourHandItem) {
                nmsPlayer.releaseUsingItem();
                this.logOperation(player, (Player)targetPlayer, OperationType.ReleaseUsingItem);
            }
        });
    }

    @Override
    public void onInteract(Player source, Action action) {
        if (action == Action.PHYSICAL) {
            return;
        }
        if (this.tracker().isDuplicatedRightClick(source)) {
            if (FeatherMorphMain.getInstance().doInternalDebugOutput) {
                this.logger.info("Interact, Duplicated RC " + System.currentTimeMillis());
            }
            return;
        }
        this.runIfChainable(source, targetPlayer -> {
            this.simulateOperation(action, (Player)targetPlayer, source);
            this.logOperation(source, (Player)targetPlayer, action.isLeftClick() ? OperationType.LeftClick : OperationType.RightClick);
        });
    }
}

