/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.world.level.block.WeatheringCopper;
import org.bukkit.craftbukkit.entity.CraftCopperGolem;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;

public class CopperGolemProperties
extends BaseLivingEntityProperties<CopperGolem> {
    public final SingleProperty<WeatherState> WEATHER_STATE = this.createProperty("copper_golem/weather_state", WeatherState.UNAFFECTED, this::readWeatherState, OutputHandles::writeEnum).withValidInput(Arrays.stream(WeatherState.values()).map(ws -> ws.name().toLowerCase()).toList());

    private Optional<WeatherState> readWeatherState(String propertyName, String input) throws ParseErrorException {
        return InputHandles.readEnumNonNull((Enum[])WeatherState.values(), (String)propertyName, (String)input);
    }

    public CopperGolemProperties() {
        this.registerSingle((SingleProperty<?>)this.WEATHER_STATE);
    }

    @Override
    @Nullable
    protected CopperGolem tryCastEntity(@Nullable Entity targetEntity) {
        CopperGolem copperGolem;
        return targetEntity instanceof CopperGolem ? (copperGolem = (CopperGolem)targetEntity) : null;
    }

    @Override
    public void setupPropertiesFromEntity(PropertyHandler propertyHandler, @NotNull CopperGolem copperGolem) {
        WeatheringCopper.WeatherState nmsWeatherState = ((CraftCopperGolem)copperGolem).getHandle().getWeatherState();
        WeatherState bukkitWeatherState = switch (nmsWeatherState) {
            default -> throw new MatchException(null, null);
            case WeatheringCopper.WeatherState.UNAFFECTED -> WeatherState.UNAFFECTED;
            case WeatheringCopper.WeatherState.EXPOSED -> WeatherState.EXPOSED;
            case WeatheringCopper.WeatherState.WEATHERED -> WeatherState.WEATHERED;
            case WeatheringCopper.WeatherState.OXIDIZED -> WeatherState.OXIDIZED;
        };
        propertyHandler.set(this.WEATHER_STATE, bukkitWeatherState);
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
    }

    public static enum WeatherState {
        UNAFFECTED,
        EXPOSED,
        WEATHERED,
        OXIDIZED;

    }
}

