/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.integrations.towny.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.metadata.BooleanDataField;
import com.palmergames.bukkit.towny.utils.MetaDataUtil;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.minecraft.network.chat.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.api.events.gameplay.MorphTownBooleanFlagChangedEvent;
import xyz.nifeather.morph.commands.brigadier.BrigadierCommand;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.CommandStrings;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class TownyFlagSubCommands {

    public static class BooleanFlagCommand
    extends BrigadierCommand {
        private final String name;
        private final BooleanDataField dataField;

        public BooleanFlagCommand(BooleanDataField dataField) {
            this.dataField = dataField;
            this.name = dataField.getKey().replaceFirst("feathermorph_", "");
        }

        @Override
        public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
            parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)this.name()).executes(this::execLookup)).then(Commands.argument((String)"new_value", (ArgumentType)BoolArgumentType.bool()).executes(this::execSetValue)));
        }

        private int execSetValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            Entity entity = ((CommandSourceStack)context.getSource()).getExecutor();
            if (!(entity instanceof Player)) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Panic! The executor is not a player!")).create();
            }
            Player player = (Player)entity;
            TownyAPI towny = TownyAPI.getInstance();
            Town town = towny.getTown(player);
            Resident resident = towny.getResident(player);
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            if (town == null) {
                MessageUtils.send(sender, CommandStrings.townyDoesntHaveTown());
                return 0;
            }
            if (resident == null) {
                MessageUtils.send(sender, CommandStrings.unknownError());
                return 0;
            }
            if (!town.isMayor(resident)) {
                MessageUtils.send(sender, CommandStrings.townyPlayerNotMayor());
                return 0;
            }
            boolean value = BoolArgumentType.getBool(context, (String)"new_value");
            MetaDataUtil.setBoolean((TownyObject)town, (BooleanDataField)this.dataField, (boolean)value, (boolean)true);
            new MorphTownBooleanFlagChangedEvent(player, town, this.dataField, value).callEvent();
            FormattableMessage message = CommandStrings.optionSetString().resolve("what", this.name()).resolve("value", value);
            MessageUtils.send(sender, message);
            return 1;
        }

        private int execLookup(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            Entity entity = ((CommandSourceStack)context.getSource()).getExecutor();
            if (!(entity instanceof Player)) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Panic! The executor is not a player!")).create();
            }
            Player player = (Player)entity;
            TownyAPI towny = TownyAPI.getInstance();
            Town town = towny.getTown(player);
            Resident resident = towny.getResident(player);
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            if (town == null) {
                MessageUtils.send(sender, CommandStrings.townyDoesntHaveTown());
                return 0;
            }
            if (resident == null) {
                MessageUtils.send(sender, CommandStrings.unknownError());
                return 0;
            }
            if (!town.isMayor(resident)) {
                MessageUtils.send(sender, CommandStrings.townyPlayerNotMayor());
                return 0;
            }
            FormattableMessage message = CommandStrings.optionValueString().resolve("what", this.name());
            if (!MetaDataUtil.hasMeta((TownyObject)town, (BooleanDataField)this.dataField)) {
                message.resolve("value", this.dataField.getValue());
            } else {
                message.resolve("value", MetaDataUtil.getBoolean((TownyObject)town, (BooleanDataField)this.dataField));
            }
            MessageUtils.send(sender, message);
            return 1;
        }

        @Override
        @Nullable
        public String getPermissionRequirement() {
            return null;
        }

        @Override
        @NotNull
        public String name() {
            return this.name;
        }

        @Override
        public FormattableMessage getHelpMessage() {
            return null;
        }
    }
}

