/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal.handles.impl;

import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import org.bukkit.craftbukkit.entity.CraftMob;
import org.bukkit.entity.Mob;
import org.slf4j.Logger;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.misc.mobs.goal.handles.IEntityGoalHandle;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.utilities.ReflectionUtils;

public abstract class BasicEntityHandle<M extends Mob>
extends MorphPluginObject
implements IEntityGoalHandle<M> {
    @Resolved(shouldSolveImmediately=true)
    private volatile MorphManager morphManager;
    @Resolved(shouldSolveImmediately=true)
    private volatile RevealingHandler revealingHandler;
    protected final Logger logger = FeatherMorphMain.getInstance().getSLF4JLogger();

    protected MorphManager morphManager() {
        return this.morphManager;
    }

    protected RevealingHandler revealingHandler() {
        return this.revealingHandler;
    }

    protected abstract Collection<WrappedGoal> filterGoals(M var1);

    protected abstract void onTargetGoalFound(M var1, WrappedGoal var2);

    @Override
    public final void apply(M mob) {
        this.addDefaultGoals(mob);
        Collection<WrappedGoal> matchingGoals = this.filterGoals(mob);
        if (matchingGoals.isEmpty()) {
            return;
        }
        this.findAvoidPlayerGoal(matchingGoals).ifPresentOrElse(g -> this.onTargetGoalFound(mob, (WrappedGoal)g), () -> this.whenNoTargetGoal(mob));
    }

    protected void addDefaultGoals(M mob) {
    }

    protected void whenNoTargetGoal(M mob) {
    }

    protected Optional<WrappedGoal> findAvoidPlayerGoal(Collection<WrappedGoal> collection) {
        for (WrappedGoal wrapped : collection) {
            Goal underlyingGoal = wrapped.getGoal();
            Class clazz = ReflectionUtils.getValue(underlyingGoal, "avoidClass", Class.class);
            if (!clazz.isAssignableFrom(Player.class)) continue;
            return Optional.of(wrapped);
        }
        return Optional.empty();
    }

    @Deprecated
    protected int getGoalPriority(M mob, WrappedGoal goal) {
        return goal.getPriority();
    }

    protected GoalSelector goalSelector(M mob) {
        return ((CraftMob)mob).getHandle().goalSelector;
    }
}

