/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal.impl;

import com.destroystokyo.paper.entity.Pathfinder;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftMob;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.utilities.EntityTypeUtils;
import xyz.nifeather.morph.utilities.FoliaThreadUtils;

public abstract class MorphBasicAvoidPlayerGoal<M extends Mob>
extends Goal {
    protected final M mob;
    protected final RevealingHandler revealingHandler;
    protected final MorphManager morphManager;
    protected final double detectDistance;
    protected final double walkSpeed;
    protected final double sprintSpeed;
    @Nullable
    private Entity entityToAvoid;
    @Nullable
    private Pathfinder.PathResult path;

    public MorphBasicAvoidPlayerGoal(M bindingMob, RevealingHandler revealingHandler, MorphManager morphManager, double detectDistance, double walkSpeed, double sprintSpeed) {
        this.mob = bindingMob;
        this.revealingHandler = revealingHandler;
        this.morphManager = morphManager;
        this.detectDistance = detectDistance;
        this.walkSpeed = walkSpeed;
        this.sprintSpeed = sprintSpeed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        this.entityToAvoid = this.findEntityToAvoid();
        if (this.entityToAvoid == null) {
            return false;
        }
        this.path = this.findEscapePath();
        return this.path != null;
    }

    public boolean canContinueToUse() {
        return !this.mob.getPathfinder().hasPath();
    }

    private Entity findEntityToAvoid() {
        double trackingDistance = this.mob.getBoundingBox().getWidthX() / 2.0 + this.detectDistance;
        List<Player> nearbyPlayers = this.mob.getNearbyEntities(trackingDistance, 3.0, trackingDistance).stream().filter(e -> e instanceof Player && FoliaThreadUtils.isTickThreadFor(e)).map(e -> (Player)e).toList();
        Player found = null;
        double currentDistance = Double.MAX_VALUE;
        Location catLocation = this.mob.getLocation();
        boolean isDisguisePanicking = false;
        for (Player player : nearbyPlayers) {
            double distance;
            GameMode gamemode = player.getGameMode();
            if (gamemode == GameMode.SPECTATOR || gamemode == GameMode.CREATIVE || (distance = player.getLocation().distance(catLocation)) > currentDistance || this.revealingHandler.shouldMobsAwareRevealed(player)) continue;
            DisguiseState state = this.morphManager.getDisguiseStateFor(player);
            if (state != null) {
                if (!EntityTypeUtils.panicsFrom(this.mob.getType(), state.getEntityType())) continue;
                isDisguisePanicking = true;
                found = player;
                break;
            }
            found = player;
        }
        if (isDisguisePanicking || this.mobPanicFromPlayerByDefault()) {
            return found;
        }
        return null;
    }

    protected boolean mobPanicFromPlayerByDefault() {
        return EntityTypeUtils.panicsFrom(this.mob.getType(), EntityType.PLAYER);
    }

    @Nullable
    private Pathfinder.PathResult findEscapePath() {
        net.minecraft.world.entity.Entity playerToAvoid;
        if (this.entityToAvoid == null) {
            return null;
        }
        PathfinderMob nmsCat = (PathfinderMob)((CraftMob)this.mob).getHandle();
        Vec3 nmsTarget = DefaultRandomPos.getPosAway((PathfinderMob)nmsCat, (int)16, (int)7, (Vec3)(playerToAvoid = ((CraftEntity)this.entityToAvoid).getHandle()).position());
        if (nmsTarget == null) {
            return null;
        }
        Location escapeLocation = new Location(this.mob.getWorld(), nmsTarget.x(), nmsTarget.y(), nmsTarget.z());
        return this.mob.getPathfinder().findPath(escapeLocation);
    }

    public void start() {
        if (this.path != null) {
            this.mob.getPathfinder().moveTo(this.path, this.sprintSpeed);
        } else {
            this.mob.getPathfinder().stopPathfinding();
        }
    }

    public void tick() {
        if (this.entityToAvoid == null || this.path == null || !FoliaThreadUtils.isTickThreadFor(this.entityToAvoid)) {
            return;
        }
        Pathfinder pathfinder = this.mob.getPathfinder();
        if (this.mob.getLocation().distance(this.entityToAvoid.getLocation()) < 49.0) {
            pathfinder.moveTo(this.path, this.sprintSpeed);
        } else {
            pathfinder.moveTo(this.path, this.walkSpeed);
        }
    }

    public void stop() {
        this.entityToAvoid = null;
        this.path = null;
    }
}

