/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal.impl;

import java.util.Optional;
import net.minecraft.world.entity.ai.goal.Goal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Panda;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.misc.mobs.goal.IGoalProvider;
import xyz.nifeather.morph.misc.mobs.goal.impl.MorphBasicAvoidPlayerGoal;

public class MorphPandaAvoidPlayerGoal
extends MorphBasicAvoidPlayerGoal<Panda> {
    public static final PandaGoalProvider GOAL_PROVIDER = new PandaGoalProvider();

    public MorphPandaAvoidPlayerGoal(Panda bindingMob, RevealingHandler revealingHandler, MorphManager morphManager, double detectDistance, double walkSpeed, double sprintSpeed) {
        super(bindingMob, revealingHandler, morphManager, detectDistance, walkSpeed, sprintSpeed);
    }

    @Override
    public boolean canUse() {
        if (((Panda)this.mob).getCombinedGene() != Panda.Gene.WORRIED) {
            return false;
        }
        if (((Panda)this.mob).isOnBack() || ((Panda)this.mob).isScared() || ((Panda)this.mob).isEating() || ((Panda)this.mob).isRolling() || ((Panda)this.mob).isSitting()) {
            return false;
        }
        return super.canUse();
    }

    @Override
    protected boolean mobPanicFromPlayerByDefault() {
        return true;
    }

    public static class PandaGoalProvider
    implements IGoalProvider<Panda> {
        @Override
        public Optional<Panda> tryCast(Entity entity) {
            Panda Panda2;
            return Optional.ofNullable(entity instanceof Panda ? (Panda2 = (Panda)entity) : null);
        }

        @Override
        public Goal createGoal(Panda mob, @NotNull MorphManager morphManager, @NotNull RevealingHandler revealingHandler, double detectDistance, double walkSpeed, double sprintSpeed) {
            return new MorphPandaAvoidPlayerGoal(mob, revealingHandler, morphManager, detectDistance, walkSpeed, sprintSpeed);
        }
    }
}

