/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.waypoint;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.misc.waypoint.connection.IMorphRealtimeWaypointConnection;
import xyz.nifeather.morph.misc.waypoint.connection.MorphAzimuthWaypointConnection;
import xyz.nifeather.morph.misc.waypoint.connection.MorphBlockConnection;
import xyz.nifeather.morph.misc.waypoint.connection.MorphChunkConnection;
import xyz.nifeather.morph.providers.disguise.DefaultDisguiseProvider;

public class DisguiseWaypointUpdater
implements WaypointTransmitter {
    private volatile boolean transmitting;
    private volatile boolean disposed;
    @Nullable
    private ServerLevel lastWorld = null;
    private volatile boolean enabled = false;
    private final DisguiseState bindingState;
    private final List<IMorphRealtimeWaypointConnection> realtimeConnections = Collections.synchronizedList(new ObjectArrayList());
    private final Waypoint.Icon waypointIcon = new Waypoint.Icon();

    public DisguiseWaypointUpdater(DisguiseState state) {
        this.bindingState = state;
    }

    public void dispose() {
        this.enabled(false);
        this.tick();
        this.disposed = true;
    }

    public void tick() {
        boolean allowConnection = this.allowWaypointConnection();
        ServerLevel currentWorld = NmsRecord.ofPlayer(this.getPlayer()).level();
        ServerWaypointManager currentWaypointManager = currentWorld.getWaypointManager();
        if (!currentWorld.equals(this.lastWorld)) {
            if (this.lastWorld != null) {
                this.lastWorld.getWaypointManager().untrackWaypoint((WaypointTransmitter)this);
            }
            this.transmitting = false;
        }
        this.lastWorld = currentWorld;
        if (this.transmitting != allowConnection) {
            if (allowConnection) {
                if (!currentWaypointManager.transmitters().contains(this)) {
                    currentWaypointManager.trackWaypoint((WaypointTransmitter)this);
                }
                this.transmitting = true;
            } else {
                this.transmitting = false;
                currentWaypointManager.untrackWaypoint((WaypointTransmitter)this);
                this.realtimeConnections.clear();
            }
        }
    }

    public boolean allowWaypointConnection() {
        AttributeModifier modifier;
        if (!this.enabled) {
            return false;
        }
        if (this.bindingState.disposed()) {
            return false;
        }
        Player player = this.bindingState.getPlayer();
        if (player.isSneaking()) {
            return false;
        }
        if (!player.isConnected()) {
            return false;
        }
        if (player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            return false;
        }
        AttributeInstance playerAttribute = player.getAttribute(Attribute.WAYPOINT_TRANSMIT_RANGE);
        if (playerAttribute != null && (modifier = playerAttribute.getModifier((Key)DefaultDisguiseProvider.WAYPOINT_TRANSMIT_MODIFIER_KEY)) != null) {
            playerAttribute.removeModifier(modifier);
            double value = playerAttribute.getValue();
            playerAttribute.addTransientModifier(modifier);
            return value > 0.0;
        }
        return true;
    }

    public void enabled(boolean value) {
        if (this.disposed) {
            return;
        }
        this.enabled = value;
        this.tick();
    }

    @NotNull
    public Player getPlayer() {
        return this.bindingState.getPlayer();
    }

    public boolean isTransmittingWaypoint() {
        return this.transmitting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRealtimeConnections() {
        if (!this.transmitting) {
            return;
        }
        List<IMorphRealtimeWaypointConnection> list = this.realtimeConnections;
        synchronized (list) {
            List<IMorphRealtimeWaypointConnection> list2 = List.copyOf(this.realtimeConnections);
            for (IMorphRealtimeWaypointConnection connection : list2) {
                if (connection.isBroken()) {
                    this.realtimeConnections.remove(connection);
                    continue;
                }
                connection.internalUpdate();
            }
        }
    }

    public Optional<WaypointTransmitter.Connection> makeWaypointConnectionWith(ServerPlayer target) {
        if (!this.transmitting) {
            return Optional.empty();
        }
        ServerPlayer player = NmsRecord.ofPlayer(this.getPlayer());
        if (player.gameMode() == GameType.SPECTATOR && target.gameMode() != GameType.SPECTATOR) {
            return Optional.empty();
        }
        if (player.equals((Object)target)) {
            return Optional.empty();
        }
        Waypoint.Icon icon = this.waypointIcon();
        if (WaypointTransmitter.isReallyFar((LivingEntity)player, (ServerPlayer)target)) {
            return Optional.of(new MorphAzimuthWaypointConnection(this.bindingState, icon, target));
        }
        CraftPlayer targetBukkit = target.getBukkitEntity();
        if (!this.bindingState.getPlayer().isTrackedBy((Player)targetBukkit)) {
            return Optional.of(new MorphChunkConnection(this.bindingState, icon, target));
        }
        MorphBlockConnection conn = new MorphBlockConnection(this.bindingState, icon, target);
        this.realtimeConnections.add(conn);
        return Optional.of(conn);
    }

    public Waypoint.Icon waypointIcon() {
        return this.waypointIcon;
    }

    public String toString() {
        Player pl = this.bindingState.getPlayer();
        String playerString = pl.getName();
        return "(Disguise Waypoint for %s)@%s".formatted(playerString, Integer.toHexString(this.hashCode()));
    }
}

