/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.shaded.pluginbase.Configuration;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.shaded.pluginbase.Configuration.ConfigNode;

public class ConfigOption<T> {
    private final ConfigNode node;
    private final Function<Object, T> defaultValueFunc;
    private final List<String> flags = new ObjectArrayList();

    public ConfigNode node() {
        return this.node;
    }

    @NotNull
    public T getDefault() {
        return this.defaultValueFunc.apply(null);
    }

    public ConfigOption(ConfigNode node, T defaultValue) {
        this(node, o -> defaultValue);
    }

    public ConfigOption(ConfigNode node, Function<Object, T> defaultValueFunc) {
        this.node = node;
        this.defaultValueFunc = defaultValueFunc;
    }

    public ConfigOption<T> withFlag(String flag) {
        if (this.containsFlag(flag)) {
            return this;
        }
        this.flags.add(flag);
        return this;
    }

    public boolean containsFlag(String flag) {
        return this.flags.stream().anyMatch(f -> f.equalsIgnoreCase(flag));
    }

    public String toString() {
        return this.node.toString();
    }

    public ConfigOption<T> setExcludeFromInit() {
        return this.withFlag("exclude_from_init");
    }

    public boolean excludeFromInit() {
        return this.containsFlag("exclude_from_init");
    }
}

