/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.shaded.pluginbase.Messages;

import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.shaded.pluginbase.Messages.IStrings;
import xyz.nifeather.morph.shaded.pluginbase.XiaMoJavaPlugin;
import xyz.nifeather.morph.shaded.pluginbase.storage.JsonBasedStorage;

public abstract class MessageStore<T extends XiaMoJavaPlugin>
extends JsonBasedStorage<Map<String, String>, T> {
    public String get(String key, @Nullable String defaultValue, @Nullable String locale) {
        String val = (String)((Map)this.storingObject).get(key);
        if (val == null) {
            val = defaultValue;
            ((Map)this.storingObject).put(key, defaultValue);
        }
        return val;
    }

    @Override
    @NotNull
    protected String getFileName() {
        return "messages.json";
    }

    @Override
    @NotNull
    protected Map<String, String> createDefault() {
        return new Object2ObjectAVLTreeMap();
    }

    @Override
    @NotNull
    protected String getDisplayName() {
        return "MessageStore";
    }

    @Override
    public boolean reloadConfiguration() {
        boolean val = super.reloadConfiguration();
        this.addMissingStrings();
        return val;
    }

    protected abstract List<Class<? extends IStrings>> getStrings();

    public void addMissingStrings() {
        List<Class<IStrings>> classes = this.getStrings();
        try {
            for (Class<IStrings> c : classes) {
                List<Method> methods = Arrays.stream(c.getMethods()).filter(m -> m.getReturnType().equals(FormattableMessage.class)).toList();
                for (Method m2 : methods) {
                    FormattableMessage formattable = (FormattableMessage)m2.invoke(null, new Object[0]);
                    String key = formattable.getKey();
                    if (!((Map)this.storingObject).containsKey(key)) {
                        ((Map)this.storingObject).put(key, formattable.getDefaultString());
                    }
                    this.saveConfiguration();
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn(t.getMessage());
            t.printStackTrace();
        }
    }
}

