/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.shaded.pluginbase.Utilities;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.NotSerializable;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Serializable;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;

public class ConfigSerializeUtils {
    private static final Logger Logger = LoggerFactory.getLogger((String)"XiaMoBase");

    public static Map<String, Object> serialize(Object o) {
        ConfigSerializeUtils.checkDuplicateNames(o);
        List<Field> fields = Arrays.stream(o.getClass().getDeclaredFields()).filter(f -> !f.isAnnotationPresent(NotSerializable.class)).toList();
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (Field f2 : fields) {
            int mod = f2.getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isFinal(mod)) {
                throw new IllegalStateException("\u4e0d\u80fd\u5e8f\u5217\u5316\u975epublic\u6216final\u5b57\u6bb5\uff1a" + f2.getName());
            }
            try {
                String serializeName = f2.isAnnotationPresent(Serializable.class) ? f2.getAnnotation(Serializable.class).value() : f2.getName();
                map.put((Object)serializeName, f2.get(o));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return map;
    }

    private static void checkDuplicateNames(Object o) {
        ObjectArrayList fields = new ObjectArrayList(Arrays.stream(o.getClass().getFields()).filter(f -> !f.isAnnotationPresent(NotSerializable.class)).toList());
        List<Field> fieldsWithAnnotation = fields.stream().filter(f -> f.isAnnotationPresent(Serializable.class)).toList();
        fields.removeAll(fieldsWithAnnotation);
        for (Field fwa : fieldsWithAnnotation) {
            String name = fwa.getAnnotation(Serializable.class).value();
            if (!fields.stream().anyMatch(f -> f.getName().equals(name))) continue;
            throw new DuplicateSerializeNameException("\u5728" + String.valueOf(o) + "\u4e2d\u627e\u5230\u4e86\u591a\u4e2a\u53eb" + name + "\u7684\u53ef\u53cd\u5e8f\u5217\u5316\u5bf9\u8c61");
        }
    }

    public static <T> T deSerialize(T o, Map<String, Object> map) {
        ConfigSerializeUtils.checkDuplicateNames(o);
        ObjectArrayList fieldsToDeSerialize = new ObjectArrayList(Arrays.stream(o.getClass().getDeclaredFields()).filter(f -> !f.isAnnotationPresent(NotSerializable.class)).toList());
        ObjectArrayList fieldsWithAnnotation = new ObjectArrayList(fieldsToDeSerialize.stream().filter(f -> f.isAnnotationPresent(Serializable.class)).toList());
        fieldsToDeSerialize.removeAll((Collection)fieldsWithAnnotation);
        for (String key : map.keySet()) {
            if (key.equals("==")) continue;
            Field field = fieldsToDeSerialize.stream().filter(f -> f.getName().equals(key)).findFirst().orElse(null);
            Field fieldWithAnnotation = fieldsWithAnnotation.stream().filter(f -> f.getAnnotation(Serializable.class).value().equals(key)).findFirst().orElse(null);
            if (field == null && fieldWithAnnotation != null) {
                field = fieldWithAnnotation;
                fieldsWithAnnotation.remove((Object)field);
            }
            if (field != null) {
                try {
                    field.set(o, map.get(key));
                    fieldsToDeSerialize.remove((Object)field);
                    continue;
                }
                catch (IllegalAccessException e) {
                    Logger.warn("\u53cd\u5e8f\u5217\u5316\u76ee\u6807\u9519\u8bef\uff1a" + String.valueOf(o));
                    throw new RuntimeException(e);
                }
            }
            Logger.warn("\u53cd\u5e8f\u5217\u5316\u76ee\u6807\u672a\u627e\u5230\uff1a" + key + " in " + String.valueOf(o));
        }
        return o;
    }

    public static boolean tryCastNumberBindable(Bindable<?> bindable, Number val) {
        try {
            Object bindableVal = bindable.get();
            if (bindableVal == null) {
                Logger.error("Bindable %s has a null value and cannot be used for number converting");
                return false;
            }
            Class<?> typeParamClazz = bindableVal.getClass();
            Number numConv = ConfigSerializeUtils.convertNumber(typeParamClazz, val, true);
            if (numConv == null) {
                Logger.error("Cannot convert input %s(%s) to a compat value for target bindable %s(%s)".formatted(val, val.getClass(), bindable, bindable));
                return false;
            }
            bindable.setInternal(numConv);
            return true;
        }
        catch (Throwable t) {
            Logger.warn("Unable to cast value for Bindable: %s".formatted(t.getMessage()));
            t.printStackTrace();
            return false;
        }
    }

    public static Number convertNumber(Class<?> type, Number input, boolean nullIfFailed) {
        if (type == Integer.class || type == Integer.TYPE) {
            return input.intValue();
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(input.floatValue());
        }
        if (type == Double.class || type == Double.TYPE) {
            return input.doubleValue();
        }
        if (type == Long.class || type == Long.TYPE) {
            return input.longValue();
        }
        if (type == Short.class || type == Short.TYPE) {
            return input.shortValue();
        }
        if (nullIfFailed) {
            return null;
        }
        throw new RuntimeException("Unable to convert input ('%s') to the target type: %s".formatted(input, type));
    }

    private static class DuplicateSerializeNameException
    extends RuntimeException {
        public DuplicateSerializeNameException(String s) {
            super(s);
        }
    }
}

