/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills.impl;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.messages.strings.SkillStrings;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSNbtCommand;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.skills.impl.DelayedMorphSkill;
import xyz.nifeather.morph.skills.options.ExplosionConfiguration;

public class ExplodeMorphSkill
extends DelayedMorphSkill<ExplosionConfiguration> {
    @Resolved
    private MorphClientHandler clientHandler;

    @Override
    public ISkillAbilityOptionHandler<ExplosionConfiguration> optionHandler() {
        return ExplosionConfiguration.OPTION_HANDLER;
    }

    @Override
    protected int getExecuteDelay(ExplosionConfiguration option) {
        return option.executeDelay;
    }

    @Override
    protected DelayedMorphSkill.ExecuteResult preExecute(Player player, DisguiseState state, @NotNull ExplosionConfiguration option) throws ExecutionErrorException {
        if (state.getEntityType() == EntityType.CREEPER) {
            state.getDisguiseWrapper().setAggressive(true);
            this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetSNbtCommand("{\"ignited\": true, \"Fuse\": 30}"));
        }
        this.playSoundToNearbyPlayers(player, 16, Key.key((String)option.getPrimedSound()), Sound.Source.HOSTILE);
        return DelayedMorphSkill.ExecuteResult.success(0);
    }

    @Override
    protected void executeDelayedSkill(Player player, DisguiseState state, ExplosionConfiguration option) {
        int strength = option.getStrength();
        boolean setsFire = option.setsFire();
        boolean killsSelf = option.killsSelf();
        if (!player.getWorld().createExplosion((Entity)player, (float)strength, setsFire, Boolean.TRUE.equals(player.getWorld().getGameRuleValue(GameRule.MOB_GRIEFING)))) {
            this.sendDenyMessageToPlayer(player, SkillStrings.explodeFailString());
            return;
        }
        if (state.getEntityType() == EntityType.CREEPER) {
            state.getDisguiseWrapper().setAggressive(false);
            this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetSNbtCommand("{\"ignited\": false, \"Fuse\": 0}"));
        }
        if (killsSelf && player.getGameMode() != GameMode.CREATIVE) {
            ServerPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
            DamageSource source = ((CraftWorld)player.getWorld()).getHandle().damageSources().explosion((net.minecraft.world.entity.Entity)nmsPlayer, null);
            nmsPlayer.hurtServer(nmsPlayer.level(), source, 1.0f);
            player.setHealth(0.0);
        }
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return SkillNames.EXPLODE;
    }
}

