/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills.impl;

import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.SkillStrings;
import xyz.nifeather.morph.misc.DisguiseEquipment;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.network.Constants;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetDisplayingFakeEquipCommand;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.providers.disguise.DisguiseProvider;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.skills.MorphSkill;
import xyz.nifeather.morph.skills.options.NoOpConfiguration;

public class InventoryMorphSkill
extends MorphSkill<NoOpConfiguration> {
    @Resolved
    private MorphManager manager;
    @Resolved
    private MorphClientHandler clientHandler;

    @Override
    public ISkillAbilityOptionHandler<NoOpConfiguration> optionHandler() {
        return NoOpConfiguration.OPTION_HANDLER;
    }

    @Override
    public int executeSkill(Player player, DisguiseState state, NoOpConfiguration option) throws ExecutionErrorException {
        boolean defaultShown = state.toggleDisguisedItems();
        this.manager.spawnCloudParticle(player, player.getLocation(), player.getWidth(), player.getHeight(), player.getWidth());
        if (this.clientHandler.getPlayerVersion(player) < Constants.ApiLevel.EQUIPMENT_AND_SKIN_ARE_NOW_PROPERTY.protocolVersion) {
            this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetDisplayingFakeEquipCommand(defaultShown));
        }
        MessageUtils.send((CommandSender)player, defaultShown ? SkillStrings.displayingDisguiseInventoryString() : SkillStrings.displayingPlayerInventoryString());
        return 0;
    }

    @Override
    public void onInitialEquip(DisguiseState state) {
        Entity targetEntity = state.getSessionData("MORPHMANAGER_TARGET_ENTITY", Entity.class);
        if (targetEntity != null) {
            DisguiseProvider provider = state.getProvider();
            DisguiseState theirState = this.manager.getDisguiseStateFor(targetEntity);
            DisguiseMeta disguiseMeta = this.manager.getDisguiseMeta(state.getDisguiseIdentifier());
            if (provider.canCloneEquipment(disguiseMeta, targetEntity, theirState)) {
                DisguiseEquipment equipment = null;
                equipment = theirState != null ? (theirState.showingDisguisedItems() ? theirState.getDisguiseEquipment() : DisguiseEquipment.copy(((LivingEntity)targetEntity).getEquipment())) : DisguiseEquipment.copy(((LivingEntity)targetEntity).getEquipment());
                state.refreshDisguiseItems(equipment);
            }
        }
        super.onInitialEquip(state);
    }

    @Override
    public void applyToClient(DisguiseState state) {
        Player player = state.getPlayer();
        if (this.clientHandler.getPlayerVersion(player) < Constants.ApiLevel.EQUIPMENT_AND_SKIN_ARE_NOW_PROPERTY.protocolVersion) {
            this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetDisplayingFakeEquipCommand(state.showingDisguisedItems()));
        }
        super.applyToClient(state);
    }

    @Override
    public void onDeEquip(DisguiseState state) {
        Player player = state.getPlayer();
        if (this.clientHandler.getPlayerVersion(player) < Constants.ApiLevel.EQUIPMENT_AND_SKIN_ARE_NOW_PROPERTY.protocolVersion) {
            this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetDisplayingFakeEquipCommand(false));
        }
        super.onDeEquip(state);
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return SkillNames.FAKE_EQUIP;
    }
}

