/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills.impl;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.WitherSkull;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.messages.strings.SkillStrings;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetAggressiveCommand;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.skills.impl.DelayedMorphSkill;
import xyz.nifeather.morph.skills.options.ProjectileConfiguration;

public class LaunchProjectileMorphSkill
extends DelayedMorphSkill<ProjectileConfiguration> {
    @Resolved
    private MorphClientHandler clientHandler;

    @Override
    public ISkillAbilityOptionHandler<ProjectileConfiguration> optionHandler() {
        return ProjectileConfiguration.OPTION_HANDLER;
    }

    @Override
    protected int getExecuteDelay(ProjectileConfiguration option) {
        return option.executeDelay;
    }

    @Override
    protected DelayedMorphSkill.ExecuteResult preExecute(Player player, DisguiseState state, @NotNull ProjectileConfiguration option) {
        this.playSoundToNearbyPlayers(player, option.getSoundDistance(), Key.key((String)option.getPreLaunchSoundName()), Sound.Source.HOSTILE);
        state.getDisguiseWrapper().setAggressive(true);
        this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetAggressiveCommand(true));
        return DelayedMorphSkill.ExecuteResult.success(0);
    }

    @Override
    protected void executeDelayedSkill(Player player, DisguiseState state, ProjectileConfiguration option) {
        state.getDisguiseWrapper().setAggressive(false);
        this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetAggressiveCommand(false));
        EntityType type = option.entityType();
        Entity target = null;
        int distanceLimit = option.getDistanceLimit();
        if (distanceLimit > 0 && (target = player.getTargetEntity(distanceLimit)) == null) {
            this.sendDenyMessageToPlayer(player, SkillStrings.noTargetString().resolve("distance", "" + distanceLimit));
            return;
        }
        Object entity = this.launchProjectile(player, type, option.getVectorMultiplier());
        if (entity instanceof ShulkerBullet) {
            ShulkerBullet bullet = (ShulkerBullet)entity;
            bullet.setTarget(target);
        }
        if (entity instanceof WitherSkull) {
            WitherSkull skull = (WitherSkull)entity;
            int rd = (int)(Math.random() * 100.0) % 4;
            skull.setCharged(rd == 0);
        }
        this.playSoundToNearbyPlayers(player, option.getSoundDistance(), Key.key((String)option.getSoundName()), Sound.Source.PLAYER);
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return SkillNames.LAUNCH_PROJECTILE;
    }
}

