/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.utilities;

import ca.spottedleaf.moonrise.common.util.TickThread;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.misc.EntityRetiredException;

public class FoliaThreadUtils {
    public static Duration DEFAULT_WAIT_TIMEOUT = Duration.ofMillis(150L);

    public static <X> X runOnRegionSync(Location location, Supplier<X> supplier, int timeout) throws CancellationException, ExecutionException, TimeoutException, InterruptedException {
        CompletableFuture<X> future = FoliaThreadUtils.delegateRegion(location, supplier);
        return future.get(timeout, TimeUnit.MILLISECONDS);
    }

    public static <X> CompletableFuture<X> delegateRegion(Location location, Supplier<X> supplier) {
        ServerLevel nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (TickThread.isTickThreadFor((Level)nmsWorld, (double)location.x(), (double)location.z())) {
            return CompletableFuture.completedFuture(supplier.get());
        }
        CompletableFuture future = new CompletableFuture();
        Bukkit.getRegionScheduler().run((Plugin)FeatherMorphMain.getInstance(), location, task -> future.complete(supplier.get()));
        return future;
    }

    public static <X, E extends Entity> X runOnEntitySync(E bukkitEntity, Function<E, X> func, Duration timeout) throws CancellationException, ExecutionException, TimeoutException, InterruptedException {
        return FoliaThreadUtils.delegateEntity(bukkitEntity, func).get(timeout.getNano(), TimeUnit.NANOSECONDS);
    }

    public static <X, E extends Entity> CompletableFuture<X> delegateEntity(E bukkitEntity, Function<E, X> func) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandleRaw();
        if (TickThread.isTickThreadFor((net.minecraft.world.entity.Entity)nmsEntity)) {
            return CompletableFuture.completedFuture(func.apply(bukkitEntity));
        }
        CompletableFuture future = new CompletableFuture();
        bukkitEntity.getScheduler().run((Plugin)FeatherMorphMain.getInstance(), task -> future.complete(func.apply(bukkitEntity)), () -> future.completeExceptionally(new EntityRetiredException()));
        return future;
    }

    public static void runAtLocationSync(Location location, Consumer<World> worldConsumer, Duration timeout) throws ExecutionException, InterruptedException, TimeoutException {
        ((CompletableFuture)FoliaThreadUtils.delegateLocation(location).thenAccept((Consumer)worldConsumer)).get(timeout.getNano(), TimeUnit.NANOSECONDS);
    }

    public static CompletableFuture<World> delegateLocation(Location location) {
        World world = location.getWorld();
        ServerLevel nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (TickThread.isTickThreadFor((Level)nmsWorld, (double)(0.0 + (double)location.getBlockX()), (double)(0.0 + (double)location.getBlockZ()))) {
            return CompletableFuture.completedFuture(world);
        }
        CompletableFuture<World> future = new CompletableFuture<World>();
        Bukkit.getRegionScheduler().run((Plugin)FeatherMorphMain.getInstance(), location, task -> future.complete(world));
        return future;
    }

    public static boolean isTickThreadFor(Entity bukkitEntity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        return TickThread.isTickThreadFor((net.minecraft.world.entity.Entity)nmsEntity);
    }

    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

