/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.utilities;

import ca.spottedleaf.moonrise.common.util.TickThread;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.Unmodifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.utilities.EntityTypeUtils;
import xyz.nifeather.morph.utilities.ReflectionUtils;

public class NmsUtils {
    private static final Logger log = LoggerFactory.getLogger(NmsUtils.class);
    private static final Map<EntityType, List<String>> syncableAttributesMap = new ConcurrentHashMap<EntityType, List<String>>();

    public static Entity spawnEntity(EntityType bukkitType, World targetWorld, Location location) {
        net.minecraft.world.entity.EntityType<?> nmsType = EntityTypeUtils.getNmsType(bukkitType);
        if (nmsType == null) {
            throw new IllegalArgumentException("No NMS EntityType for bukkit type '%s'".formatted(bukkitType));
        }
        ServerLevel nmsWorld = ((CraftWorld)targetWorld).getHandle();
        net.minecraft.world.entity.Entity nmsEntity = nmsType.create((Level)nmsWorld, EntitySpawnReason.COMMAND);
        if (nmsEntity == null) {
            throw new IllegalArgumentException("Unable to spawn entity");
        }
        nmsEntity.setPos(new Vec3(location.x(), location.y(), location.z()));
        return nmsEntity.getBukkitEntity();
    }

    public static ServerLevel getNmsLevel(World world) {
        return ((CraftWorld)world).getHandle();
    }

    public static List<AttributeInstance> getValidAttributes(EntityType targetType, AttributeMap mapToLookup) {
        List<String> validAttributes = NmsUtils.getSyncableAttributeListFor(targetType);
        if (validAttributes.isEmpty()) {
            return new ObjectArrayList();
        }
        ObjectArrayList existing = new ObjectArrayList(mapToLookup.getSyncableAttributes());
        existing.removeIf(instance -> validAttributes.stream().noneMatch(s -> s.equals(instance.getAttribute().getRegisteredName())));
        return existing;
    }

    public static @Unmodifiable List<String> getSyncableAttributeListFor(EntityType bukkitType) {
        Logger logger = FeatherMorphMain.getInstance().getSLF4JLogger();
        List cached = syncableAttributesMap.getOrDefault(bukkitType, null);
        if (cached != null) {
            return cached;
        }
        if (!bukkitType.isAlive()) {
            return List.of();
        }
        net.minecraft.world.entity.EntityType<?> nmsType = EntityTypeUtils.getNmsType(bukkitType);
        if (nmsType == null || !DefaultAttributes.hasSupplier(nmsType)) {
            return List.of();
        }
        List<Field> lists = ReflectionUtils.getFields(new Attributes(), Holder.class, false);
        List<Field> holders = lists.stream().filter(f -> Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers())).toList();
        Object2ObjectOpenHashMap attributesTempMap = new Object2ObjectOpenHashMap();
        holders.forEach(arg_0 -> NmsUtils.lambda$getSyncableAttributeListFor$5(nmsType, (Map)attributesTempMap, logger, arg_0));
        ArrayList validAttributes = attributesTempMap.values().stream().filter(instance -> ((Attribute)instance.getAttribute().value()).isClientSyncable() && !instance.getAttribute().getRegisteredName().equals("[unregistered]")).map(instance -> instance.getAttribute().getRegisteredName()).collect(Collectors.toCollection(ArrayList::new));
        syncableAttributesMap.put(bukkitType, Collections.synchronizedList(validAttributes));
        return validAttributes;
    }

    public static boolean isTickThreadFor(Entity entity) {
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        return TickThread.isTickThreadFor((net.minecraft.world.entity.Entity)nms);
    }

    private static /* synthetic */ void lambda$getSyncableAttributeListFor$5(net.minecraft.world.entity.EntityType nmsType, Map attributesTempMap, Logger logger, Field f) {
        try {
            Holder holderInstance;
            Object obj = f.get(null);
            if (obj instanceof Holder) {
                holderInstance = (Holder)obj;
                if (!(holderInstance.value() instanceof Attribute)) {
                    throw new IllegalArgumentException("The type of the holder is not a attribute! Got '%s'".formatted(holderInstance.value().getClass()));
                }
            } else {
                throw new IllegalArgumentException("The field '%s' is not a Holder type! Got '%s'".formatted(f.getName(), f.getType()));
            }
            Holder holder = holderInstance;
            AttributeSupplier supplier = DefaultAttributes.getSupplier((net.minecraft.world.entity.EntityType)nmsType);
            attributesTempMap.computeIfAbsent(holder, holderx -> supplier.createInstance(mod -> {}, holderx));
        }
        catch (Throwable t) {
            logger.error("Can't activate attribute: " + t.getMessage());
        }
    }
}

