/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.fmccl.network.commands.C2S;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.fmccl.network.BasicClientHandler;
import xyz.nifeather.fmccl.network.annotations.Environment;
import xyz.nifeather.fmccl.network.annotations.EnvironmentType;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SCommand;

public class NetheriteC2SOptionCommand
extends NetheriteC2SCommand<ClientOptions> {
    private String value;

    public NetheriteC2SOptionCommand(@NotNull ClientOptions option) {
        super(option);
    }

    @Override
    @Environment(value=EnvironmentType.SERVER)
    public void onCommand(BasicClientHandler<?> listener) {
        listener.onOptionCommand(this);
    }

    public NetheriteC2SOptionCommand setValue(String value) {
        this.value = value;
        return this;
    }

    public NetheriteC2SOptionCommand setValue(Boolean value) {
        return this.setValue(value != false ? "true" : "false");
    }

    public ClientOptions getOption() {
        return (ClientOptions)((Object)this.getArgumentAt(0));
    }

    public String getValue() {
        return this.value;
    }

    @Nullable
    public static NetheriteC2SOptionCommand fromString(String rawArgs) {
        String[] spilt = rawArgs.split(" ", 2);
        if (spilt.length < 2) {
            return null;
        }
        ClientOptions option = Arrays.stream(ClientOptions.values()).filter(v -> v.networkName.equalsIgnoreCase(spilt[0])).findFirst().orElse(null);
        if (option == null) {
            return null;
        }
        String value = spilt[1];
        NetheriteC2SOptionCommand instance = new NetheriteC2SOptionCommand(option);
        instance.setValue(value);
        return instance;
    }

    @Override
    public String getBaseName() {
        return "option";
    }

    @Override
    public String buildCommand() {
        return this.getBaseName() + " " + Objects.requireNonNull((ClientOptions)((Object)this.getArgumentAt((int)0))).networkName + " " + this.value;
    }

    public static enum ClientOptions {
        CLIENTVIEW("clientview"),
        HUD("hud");

        public final String networkName;

        private ClientOptions(String optionNetworkName) {
            this.networkName = optionNetworkName;
        }
    }
}

