/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph;

import com.destroystokyo.paper.profile.PlayerProfile;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.io.InvalidObjectException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.api.events.gameplay.PlayerDisguisedFromOfflineStateEvent;
import xyz.nifeather.morph.api.events.gameplay.PlayerMorphEarlyEvent;
import xyz.nifeather.morph.api.events.gameplay.PlayerMorphEvent;
import xyz.nifeather.morph.api.events.gameplay.PlayerUnMorphEarlyEvent;
import xyz.nifeather.morph.api.events.gameplay.PlayerUnMorphEvent;
import xyz.nifeather.morph.api.events.lifecycle.ManagerFinishedInitializeEvent;
import xyz.nifeather.morph.api.events.misc.DataStoreSwitchEvent;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.backends.DisguiseBackend;
import xyz.nifeather.morph.backends.DisguiseWrapper;
import xyz.nifeather.morph.backends.WrapperProperties;
import xyz.nifeather.morph.backends.client.ModBackend;
import xyz.nifeather.morph.backends.server.ServerBackend;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.interfaces.IManagePlayerData;
import xyz.nifeather.morph.messages.CommandStrings;
import xyz.nifeather.morph.messages.HintStrings;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.MorphStrings;
import xyz.nifeather.morph.misc.BoundingBoxLookup;
import xyz.nifeather.morph.misc.DisguiseBuildResult;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.DisguiseStateGenerator;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.misc.ModNetworkingHelper;
import xyz.nifeather.morph.misc.MorphParameters;
import xyz.nifeather.morph.misc.NilCommandSource;
import xyz.nifeather.morph.misc.OfflineDisguiseResult;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.values.AbstractProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.OffTreeProperties;
import xyz.nifeather.morph.network.Constants;
import xyz.nifeather.morph.network.PlayerOptions;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CUpdatePropertiesCommand;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CRemoveAdminRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CSyncAdminRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetAvailableAnimationsCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetDisplayingFakeEquipCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetMobRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetProfileCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSNbtCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSelfViewingStatusCommand;
import xyz.nifeather.morph.network.multiInstance.MultiInstanceService;
import xyz.nifeather.morph.network.multiInstance.protocol.Operation;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.network.server.PlayerSession;
import xyz.nifeather.morph.providers.disguise.DisguiseProvider;
import xyz.nifeather.morph.providers.disguise.DisguiseResult;
import xyz.nifeather.morph.providers.disguise.FallbackDisguiseProvider;
import xyz.nifeather.morph.providers.disguise.PlayerDisguiseProvider;
import xyz.nifeather.morph.providers.disguise.VanillaDisguiseProvider;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.BindableList;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.skills.SkillManager;
import xyz.nifeather.morph.storage.offlinestore.OfflineDisguiseState;
import xyz.nifeather.morph.storage.offlinestore.OfflineStateStore;
import xyz.nifeather.morph.storage.playerdata.PlayerDataStoreNew;
import xyz.nifeather.morph.storage.playerdata.PlayerMeta;
import xyz.nifeather.morph.utilities.DisguiseUtils;
import xyz.nifeather.morph.utilities.PermissionUtils;

public class MorphManager
extends MorphPluginObject
implements IManagePlayerData {
    private final List<DisguiseState> activeDisguises = ObjectLists.synchronize((ObjectList)new ObjectArrayList());
    private final IManagePlayerData defaultData = new PlayerDataStoreNew();
    @NotNull
    private volatile IManagePlayerData data = new PlayerDataStoreNew();
    private final OfflineStateStore offlineStorage = new OfflineStateStore();
    @Resolved
    private SkillManager skillManager;
    @Resolved
    private MorphConfigManager config;
    @Resolved
    private ModNetworkingHelper modNetworkingHelper;
    @Resolved
    private MultiInstanceService multiInstanceService;
    @Resolved
    private DisguiseProperties disguiseProperties;
    public static final DisguiseProvider fallbackProvider = new FallbackDisguiseProvider();
    public static final String disguiseFallbackName = "@default";
    public static final String forcedDisguiseNoneId = "@none";
    private final ModBackend modBackend;
    @NotNull
    private DisguiseBackend<?, ?> defaultBackend = this.modBackend = new ModBackend();
    private final Map<String, DisguiseBackend<?, ?>> backends = new Object2ObjectArrayMap();
    @Resolved
    private MorphClientHandler clientHandler;
    private final Map<UUID, Long> uuidMoprhTimeMap = new ConcurrentHashMap<UUID, Long>();
    private BindableList<String> bannedDisguises;
    private BindableList<String> disabledWorlds;
    private static final List<DisguiseProvider> providers = new CopyOnWriteArrayList<DisguiseProvider>();
    private final Bindable<Boolean> allowHeadMorph = new Bindable<Boolean>(true);
    private final Bindable<Boolean> allowAcquireMorph = new Bindable<Boolean>(true);
    private final Bindable<Boolean> useClientRenderer = new Bindable<Boolean>(false);
    private final Bindable<String> uuidRandomBaseString = new Bindable<String>("???");
    public static final int VALIDATE_NO_ISSUE = 0;
    public static final int VALIDATE_NO_PROVIDER = 1;
    public static final int VALIDATE_PROVIDER_FAIL = 2;
    public static final NilCommandSource nilCommandSource = new NilCommandSource();
    @Resolved
    private RevealingHandler revealingHandler;

    public IManagePlayerData getDataStore() {
        return this.data;
    }

    public void setDataStore(@Nullable IManagePlayerData newDataStore) {
        this.data = newDataStore == null ? this.defaultData : newDataStore;
        this.logger.info("Updating Player Data Store to %s".formatted(newDataStore));
        this.reloadConfiguration();
        new DataStoreSwitchEvent(this, this.data).callEvent();
    }

    public MorphManager() {
        this.offlineStorage.initializeStorage();
    }

    @NotNull
    public DisguiseBackend<?, ?> getDefaultBackend() {
        return this.defaultBackend;
    }

    public boolean registerBackend(DisguiseBackend<?, ?> backend) {
        String id = backend.getIdentifier();
        if (this.backends.containsKey(id)) {
            return false;
        }
        this.backends.put(id, backend);
        return true;
    }

    @Nullable
    public DisguiseBackend<?, ?> getBackend(String id) {
        return this.backends.getOrDefault(id, null);
    }

    @Nullable
    public <I, W extends DisguiseWrapper<I>, T extends DisguiseBackend<I, W>> T getBackend(String id, Class<T> exceptedClass) {
        DisguiseBackend<?, ?> backend = this.getBackend(id);
        if (exceptedClass.isInstance(backend)) {
            return (T)backend;
        }
        return null;
    }

    public Collection<DisguiseBackend<?, ?>> listManagedBackends() {
        return this.backends.values();
    }

    @ApiStatus.Internal
    public boolean switchBackend(DisguiseBackend<?, ?> backend) {
        if (!this.backends.containsKey(backend.getIdentifier())) {
            this.logger.error("Trying to switch to a backend that is not registered");
            return false;
        }
        try {
            this.defaultBackend = backend;
            this.unMorphAll(false);
        }
        catch (Throwable t) {
            this.logger.error("Error occurred switching backend", t);
            return false;
        }
        return true;
    }

    private void tryBackends() {
        try {
            ServerBackend serverBackend = new ServerBackend();
            this.registerBackend(serverBackend);
            this.switchBackend(serverBackend);
        }
        catch (NoClassDefFoundError e) {
            this.logger.error("Unable to initialize ServerBackend as our disguise backend, maybe PacketEvents is not installed on the server.");
            this.logger.error("Using NilBackend, displaying disguises at the server side will not be supported this run.");
        }
        catch (Throwable t) {
            this.logger.error("Unable to initialize ServerBackend as our disguise backend", t);
            this.logger.error("Using NilBackend, displaying disguises at the server side will not be supported this run.");
            this.logger.error("Please consider reporting this issue to our GitHub: https://github.com/MATRIX-feather/FeatherMorph/issues");
        }
    }

    @Deprecated(forRemoval=true)
    public Material getActionItem() {
        return Material.AIR;
    }

    @Initializer
    private void load() {
        this.registerBackend(this.modBackend);
        this.tryBackends();
        this.logger.info("Default backend: %s".formatted(this.defaultBackend));
        this.bannedDisguises = this.config.getBindableList(String.class, ConfigOption.BANNED_DISGUISES);
        this.disabledWorlds = this.config.getBindableList(String.class, ConfigOption.DISGUISE_DISABLED_WORLDS);
        this.config.bind(this.allowHeadMorph, ConfigOption.ALLOW_HEAD_MORPH);
        this.config.bind(this.allowAcquireMorph, ConfigOption.ALLOW_ACQUIRE_MORPHS);
        this.config.bind(this.useClientRenderer, ConfigOption.USE_CLIENT_RENDERER);
        this.config.bind(this.uuidRandomBaseString, ConfigOption.UUID_RANDOM_BASE);
        this.registerProviders((List<DisguiseProvider>)ObjectList.of((Object)new VanillaDisguiseProvider(), (Object)new PlayerDisguiseProvider(), (Object)fallbackProvider));
        Bukkit.getPluginManager().callEvent((Event)new ManagerFinishedInitializeEvent(this));
    }

    public boolean disguiseDisabledInWorld(World world) {
        return this.disguiseDisabledInWorld(world.getName());
    }

    public boolean disguiseDisabledInWorld(String worldName) {
        return this.disabledWorlds.contains(worldName);
    }

    public void executeDisguiseSkill(Player player) {
        DisguiseState state = this.getDisguiseStateFor(player);
        if (state == null) {
            return;
        }
        state.executeSkillCheckPermission();
    }

    public List<DisguiseState> getActiveDisguises() {
        return new ObjectArrayList(this.activeDisguises);
    }

    public boolean canMorph(Player player) {
        return this.canMorph(player.getUniqueId());
    }

    public boolean canMorph(UUID uuid) {
        Long val = this.uuidMoprhTimeMap.get(uuid);
        return val == null || this.plugin.getCurrentTick() - val >= 4L;
    }

    public void updateLastPlayerMorphOperationTime(Player player) {
        this.uuidMoprhTimeMap.put(player.getUniqueId(), this.plugin.getCurrentTick());
    }

    @ApiStatus.Internal
    public BindableList<String> getBannedDisguises() {
        return this.bannedDisguises;
    }

    public static List<DisguiseProvider> getProviders() {
        return new ObjectArrayList(providers);
    }

    @NotNull
    public static DisguiseProvider getProvider(String id) {
        if (id == null) {
            return fallbackProvider;
        }
        id = (String)id + ":";
        String[] splitedId = ((String)id).split(":", 2);
        return providers.stream().filter(p -> p.getNameSpace().equals(splitedId[0])).findFirst().orElse(fallbackProvider);
    }

    public boolean registerProvider(DisguiseProvider provider) {
        if (provider.getNameSpace().contains(":")) {
            this.logger.error("Can't register disguise provider: Illegal character found in namespace: ':'");
            return false;
        }
        if (providers.stream().anyMatch(p -> p.getNameSpace().equals(provider.getNameSpace()))) {
            this.logger.error("Can't register disguise provider: Another provider instance already registered as " + provider.getNameSpace() + " !");
            return false;
        }
        providers.add(provider);
        return true;
    }

    public boolean registerProviders(List<DisguiseProvider> providers) {
        AtomicBoolean success = new AtomicBoolean(false);
        providers.forEach(p -> success.set(this.registerProvider((DisguiseProvider)p) || success.get()));
        return success.get();
    }

    public boolean tryQuickDisguise(Player player) {
        ItemStack mainHandItem = player.getEquipment().getItemInMainHand();
        Material mainHandItemType = mainHandItem.getType();
        if (DisguiseUtils.validForHeadMorph(mainHandItemType)) {
            if (!this.allowHeadMorph.get().booleanValue()) {
                return true;
            }
            if (!player.hasPermission("feathermorph.headmorph")) {
                player.sendMessage(MessageUtils.prefixes((CommandSender)player, CommandStrings.noPermissionMessage()));
                return true;
            }
            if (!this.canMorph(player)) {
                player.sendMessage(MessageUtils.prefixes((CommandSender)player, MorphStrings.disguiseCoolingDownString()));
                return true;
            }
            Entity targetEntity = player.getTargetEntity(5);
            switch (mainHandItemType) {
                case PIGLIN_HEAD: {
                    this.morphOrUnMorph(player, EntityType.PIGLIN.getKey().asString(), targetEntity);
                    break;
                }
                case DRAGON_HEAD: {
                    this.morphOrUnMorph(player, EntityType.ENDER_DRAGON.getKey().asString(), targetEntity);
                    break;
                }
                case ZOMBIE_HEAD: {
                    this.morphOrUnMorph(player, EntityType.ZOMBIE.getKey().asString(), targetEntity);
                    break;
                }
                case SKELETON_SKULL: {
                    this.morphOrUnMorph(player, EntityType.SKELETON.getKey().asString(), targetEntity);
                    break;
                }
                case WITHER_SKELETON_SKULL: {
                    this.morphOrUnMorph(player, EntityType.WITHER_SKELETON.getKey().asString(), targetEntity);
                    break;
                }
                case PLAYER_HEAD: {
                    PlayerProfile profile = ((SkullMeta)mainHandItem.getItemMeta()).getPlayerProfile();
                    if (profile == null) {
                        player.sendMessage(MessageUtils.prefixes((CommandSender)player, MorphStrings.invalidSkinString()));
                        return true;
                    }
                    this.morph((CommandSender)player, player, DisguiseTypes.PLAYER.toId(profile.getName()), targetEntity);
                }
            }
            this.updateLastPlayerMorphOperationTime(player);
        } else {
            Entity targetedEntity = player.getTargetEntity(5);
            if (targetedEntity instanceof LivingEntity) {
                DisguiseState theirState;
                Player targetPlayer;
                DisguiseState playerState;
                String targetKey = targetedEntity instanceof Player ? ((playerState = this.getDisguiseStateFor(targetPlayer = (Player)targetedEntity)) != null ? playerState.getDisguiseIdentifier() : DisguiseTypes.PLAYER.toId(targetPlayer.getName())) : ((theirState = this.getDisguiseStateFor(targetedEntity)) != null ? theirState.getDisguiseIdentifier() : targetedEntity.getType().getKey().asString());
                this.morph((CommandSender)player, player, targetKey, targetedEntity);
                return true;
            }
        }
        return false;
    }

    public void morphOrUnMorph(Player player, String key, @Nullable Entity targetEntity) {
        DisguiseState state = this.getDisguiseStateFor(player);
        if (state != null && state.getDisguiseIdentifier().equals(key)) {
            this.unMorph(player);
        } else {
            this.morph((CommandSender)player, player, key, targetEntity);
        }
    }

    public boolean morph(CommandSender source, Player player, String key, @Nullable Entity targetEntity) {
        MorphParameters parameters = MorphParameters.create(player, key).setSource(source).setTargetedEntity(targetEntity);
        return this.doDisguise(parameters);
    }

    public boolean morph(CommandSender source, Player player, String key, @Nullable Entity targetEntity, boolean forceExecute) {
        MorphParameters parameters = MorphParameters.create(player, key).setForceExecute(forceExecute).setSource(source).setTargetedEntity(targetEntity);
        return this.doDisguise(parameters);
    }

    public boolean morph(MorphParameters parameters) {
        return this.doDisguise(parameters);
    }

    private boolean doDisguise(MorphParameters parameters) {
        Player source = parameters.commandSource == null ? parameters.targetPlayer : parameters.commandSource;
        try {
            DisguiseMeta meta = this.prepareDisguiseMeta(parameters);
            if (meta == null) {
                return false;
            }
            this.updateLastPlayerMorphOperationTime(parameters.targetPlayer);
            int validateResult = this.validateDisguise(meta);
            switch (validateResult) {
                case 0: {
                    break;
                }
                case 1: {
                    this.logger.error("Unable to find any provider that matches the identifier '%s'".formatted(parameters.targetDisguiseIdentifier()));
                    source.sendMessage(MessageUtils.prefixes((CommandSender)source, MorphStrings.disguiseBannedOrNotSupportedString()));
                    return false;
                }
                case 2: {
                    source.sendMessage(MessageUtils.prefixes((CommandSender)source, MorphStrings.invalidIdentityString()));
                    return false;
                }
                default: {
                    throw new InvalidObjectException("Invalid validate result: " + validateResult);
                }
            }
            DisguiseBuildResult buildResult = this.prepareDisguiseState(parameters, meta);
            if (!buildResult.success()) {
                return false;
            }
            PlayerMeta playerMeta = this.getPlayerMeta((OfflinePlayer)parameters.targetPlayer);
            this.buildDisguise(buildResult, parameters, playerMeta);
            if (!this.applyDisguise(parameters, buildResult.state(), meta, playerMeta)) {
                return false;
            }
            this.afterDisguise(buildResult, parameters, playerMeta);
            return true;
        }
        catch (ParseErrorException e) {
            if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                this.logger.warn("Unable to disguise player because a ParseErrorException has occurred", (Throwable)e);
            }
            FormattableMessage message = e.localizableMessage.orElseGet(() -> new FormattableMessage(this.plugin, e.getMessage())).withLocale(MessageUtils.getLocale((CommandSender)source));
            FormattableMessage msg = MorphStrings.errorWhileDisguisingUserFault().resolve("error", message).resolve("what", e.propertyName);
            Component component = MessageUtils.prefixes((CommandSender)source, msg).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)e.getMessage())));
            source.sendMessage(component);
            return false;
        }
        catch (Exception e) {
            this.logger.error("Unable to disguise player", (Throwable)e);
            source.sendMessage(MessageUtils.prefixes((CommandSender)source, MorphStrings.errorWhileDisguisingWithError().resolve("error", e.getMessage())));
            this.unMorph(parameters.targetPlayer);
            return false;
        }
    }

    @Nullable
    private DisguiseMeta prepareDisguiseMeta(MorphParameters parameters) {
        NilCommandSource source = parameters.commandSource == null ? nilCommandSource : parameters.commandSource;
        Player player = parameters.targetPlayer;
        String disguiseIdentifier = parameters.targetDisguiseIdentifier();
        if (!parameters.bypassPermission) {
            boolean hasPerm;
            String childNode = "feathermorph.morph.as." + disguiseIdentifier.replace(":", ".");
            boolean bl = hasPerm = player.hasPermission("feathermorph.morph") && PermissionUtils.hasPermission(player, childNode, true);
            if (!hasPerm) {
                source.sendMessage(MessageUtils.prefixes((CommandSender)source, CommandStrings.noPermissionMessage()));
                return null;
            }
        }
        if (!disguiseIdentifier.contains(":")) {
            disguiseIdentifier = DisguiseTypes.VANILLA.toId(disguiseIdentifier);
            parameters.setDisguiseIdentifier(disguiseIdentifier);
        }
        if (this.disguiseDisabled(disguiseIdentifier)) {
            source.sendMessage(MessageUtils.prefixes((CommandSender)source, MorphStrings.disguiseBannedOrNotSupportedString()));
            return null;
        }
        if (this.disguiseDisabledInWorld(player.getWorld())) {
            source.sendMessage(MessageUtils.prefixes((CommandSender)source, MorphStrings.disguiseDisabledInWorldString()));
            return null;
        }
        boolean earlyEventPassed = new PlayerMorphEarlyEvent(player, disguiseIdentifier, parameters.forceExecute, parameters.propertiesInput).callEvent();
        if (!parameters.forceExecute && !earlyEventPassed) {
            source.sendMessage(MessageUtils.prefixes((CommandSender)source, MorphStrings.operationCancelledString()));
            return null;
        }
        DisguiseMeta info = null;
        if (!parameters.bypassAvailableCheck) {
            String finalKey = disguiseIdentifier;
            info = this.getAvaliableDisguisesFor(player).stream().filter(i -> i.getIdentifier().equals(finalKey)).findFirst().orElse(null);
        } else if (!disguiseIdentifier.equals("minecraft:player")) {
            info = new DisguiseMeta(disguiseIdentifier, DisguiseTypes.fromId(disguiseIdentifier));
        }
        if (info == null) {
            source.sendMessage(MessageUtils.prefixes((CommandSender)source, MorphStrings.morphNotOwnedString()));
            return null;
        }
        return info;
    }

    public int validateDisguise(DisguiseMeta meta) {
        String disguiseIdentifier = meta.getIdentifier();
        String[] strippedKey = disguiseIdentifier.split(":", 2);
        DisguiseProvider provider = MorphManager.getProvider(strippedKey[0]);
        if (provider.equals(fallbackProvider)) {
            return 1;
        }
        if (!provider.isValid(disguiseIdentifier)) {
            return 2;
        }
        return 0;
    }

    @NotNull
    private DisguiseBuildResult prepareDisguiseState(MorphParameters parameters, DisguiseMeta disguiseMeta) {
        NilCommandSource source = parameters.commandSource == null ? nilCommandSource : parameters.commandSource;
        Player player = parameters.targetPlayer;
        String disguiseIdentifier = parameters.targetDisguiseIdentifier();
        Entity targetEntity = parameters.targetedEntity;
        DisguiseState outComingState = null;
        try {
            DisguiseProvider provider = MorphManager.getProvider(disguiseIdentifier);
            DisguiseResult result = provider.makeWrapper(player, disguiseMeta, targetEntity);
            if (!result.success()) {
                if (!result.failSilent()) {
                    source.sendMessage(MessageUtils.prefixes((CommandSender)source, MorphStrings.errorWhileDisguising()));
                    this.logger.error("Unable to get disguise for player with provider {}", (Object)provider);
                }
                return DisguiseBuildResult.FAILED;
            }
            DisguiseWrapper<?> wrapper = result.wrapperInstance();
            assert (wrapper != null);
            wrapper.writeProperty(WrapperProperties.DISGUISE_ID, disguiseIdentifier);
            EntityEquipment equipment = null;
            DisguiseState theirState = this.getDisguiseStateFor(targetEntity);
            if (targetEntity != null && provider.canCloneEquipment(disguiseMeta, targetEntity, theirState)) {
                equipment = theirState != null ? (theirState.showingDisguisedItems() ? theirState.getDisguisedItems() : ((LivingEntity)targetEntity).getEquipment()) : ((LivingEntity)targetEntity).getEquipment();
            }
            boolean rawIdentifierHasSkill = this.skillManager.hasSkill(disguiseIdentifier) || this.skillManager.hasSpeficSkill(disguiseIdentifier, SkillNames.NONE);
            String targetSkillID = rawIdentifierHasSkill ? disguiseIdentifier : provider.getNameSpace() + ":@default";
            PlayerMeta playerMorphConfig = this.getPlayerMeta((OfflinePlayer)player);
            outComingState = new DisguiseState(player, disguiseIdentifier, targetSkillID, wrapper, provider, equipment, this.clientHandler.getPlayerOption(player, true), playerMorphConfig);
            return DisguiseBuildResult.of(outComingState, provider, disguiseMeta);
        }
        catch (IllegalArgumentException iae) {
            source.sendMessage(MessageUtils.prefixes((CommandSender)source, MorphStrings.parseErrorString().resolve("id", disguiseIdentifier)));
            this.logger.error("Unable to parse key " + disguiseIdentifier, (Throwable)iae);
            this.unMorph(player);
            return DisguiseBuildResult.FAILED;
        }
        catch (Throwable t) {
            source.sendMessage(MessageUtils.prefixes((CommandSender)source, MorphStrings.errorWhileDisguising()));
            this.logger.error("Error while disguising", t);
            this.unMorph(player);
            return DisguiseBuildResult.FAILED;
        }
    }

    private void buildDisguise(DisguiseBuildResult result, MorphParameters parameters, PlayerMeta playerOptions) throws ParseErrorException, NullPointerException {
        if (!result.success()) {
            throw new IllegalArgumentException("Passing a failed result to postDisguise() !");
        }
        Player player = parameters.targetPlayer;
        Entity targetEntity = parameters.targetedEntity;
        DisguiseProvider provider = result.provider();
        DisguiseState state = result.state();
        DisguiseWrapper<?> wrapper = state.getDisguiseWrapper();
        String str = this.uuidRandomBaseString.get() + parameters.targetDisguiseIdentifier() + player.getName();
        UUID virtualEntityUUID = UUID.nameUUIDFromBytes(str.getBytes());
        wrapper.writeProperty(OffTreeProperties.VIRTUAL_ENTITY_UUID, virtualEntityUUID);
        PropertyHandler propertyHandler = state.disguisePropertyHandler();
        AbstractProperties<?> properties = this.disguiseProperties.get(state.getEntityType());
        propertyHandler.initProperties(properties);
        provider.setupProperties(state, targetEntity);
        propertyHandler.updateFromPropertiesInput(parameters.propertiesInput);
        propertyHandler.getAll().forEach((property, value) -> wrapper.writeProperty(property, value));
        Component customName = propertyHandler.getOr("entity/custom_name", null);
        if (customName == null) {
            String disguiseID = parameters.targetDisguiseIdentifier();
            Component playerDisplay = provider.getDisplayName(disguiseID, MessageUtils.getLocale(player));
            Component serverDisplay = provider.getDisplayName(disguiseID, this.config.get(String.class, ConfigOption.LANGUAGE_CODE));
            state.setPlayerDisplay(playerDisplay);
            state.setServerDisplay(serverDisplay);
        }
        provider.buildDisguise(state, targetEntity);
        wrapper.postBuildDisguise(state, targetEntity);
        long availableAfter = this.skillManager.getAvailableAfter(player.getUniqueId(), state.getDisguiseIdentifier());
        state.setAvailableAfter(Math.max(this.plugin.getCurrentTick() + 40L, availableAfter), true);
    }

    private boolean applyDisguise(MorphParameters parameters, DisguiseState newState, DisguiseMeta meta, PlayerMeta playerOptions) {
        boolean backendSuccess;
        Player player = parameters.targetPlayer;
        DisguiseProvider provider = MorphManager.getProvider(parameters.targetDisguiseIdentifier());
        DisguiseWrapper<?> wrapper = newState.getDisguiseWrapper();
        Player source = parameters.commandSource == null ? parameters.targetPlayer : parameters.commandSource;
        DisguiseState currentState = this.getDisguiseStateFor(player);
        if (currentState != null) {
            currentState.dispose();
            this.activeDisguises.remove(currentState);
        }
        if (!(backendSuccess = wrapper.getBackend().disguise(player, wrapper))) {
            this.logger.warn("Backend '%s' failed to disguise the player...".formatted(wrapper.getBackend().getIdentifier()));
            source.sendMessage(MessageUtils.prefixes((CommandSender)source, MorphStrings.errorWhileDisguising()));
            return false;
        }
        provider.onDisguiseApply(newState);
        ((CompletableFuture)newState.getStateFuture().thenAccept(this.activeDisguises::remove)).exceptionally(t -> {
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, MorphStrings.errorWhileUpdatingDisguise()));
            this.unMorph((CommandSender)nilCommandSource, player, true, true);
            return null;
        });
        newState.scheduleSelfUpdate();
        this.activeDisguises.add(newState);
        newState.setServerSideSelfVisible(playerOptions.showDisguiseToSelf && !this.clientViewAvailable(player));
        this.modNetworkingHelper.sendCommandToRevealablePlayers(this.modNetworkingHelper.genPartialMapCommand(newState));
        this.clientHandler.updateCurrentIdentifier(player, newState.getDisguiseIdentifier());
        newState.getSkill().applyToClient(newState);
        newState.applyCooldownToClient();
        if (provider.validForClient(newState)) {
            PlayerSession clientSession = this.clientHandler.getSession(player);
            if (clientSession != null && clientSession.apiVersion < Constants.ApiLevel.NETWORK_DISGUISE_PROPERTIES.protocolVersion) {
                this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetSNbtCommand(newState.getCulledNbtString()));
            } else {
                this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CUpdatePropertiesCommand(newState.disguisePropertyHandler().toNetworkProperties()));
            }
            provider.getInitialSyncCommands(newState).forEach(s -> this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)s));
            if (newState.haveProfile()) {
                this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetProfileCommand(newState.getProfileNbtString()));
            }
        }
        List<String> availableAnimations = provider.getAnimationProvider().getAnimationSetFor(newState.getDisguiseIdentifier()).getAvailableAnimationsForClient();
        this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetAvailableAnimationsCommand(availableAnimations));
        new PlayerMorphEvent(player, newState).callEvent();
        return true;
    }

    private void afterDisguise(DisguiseBuildResult result, MorphParameters parameters, PlayerMeta playerOptions) {
        boolean isClientPlayer;
        double cZ;
        NilCommandSource source = parameters.commandSource == null ? nilCommandSource : parameters.commandSource;
        Player player = parameters.targetPlayer;
        DisguiseMeta disguiseMeta = result.meta();
        boolean isDirect = source.equals(player);
        String playerLocale = MessageUtils.getLocale((CommandSender)source);
        FormattableMessage morphSuccessMessage = (isDirect ? MorphStrings.morphSuccessString() : CommandStrings.morphedSomeoneString()).withLocale(playerLocale).resolve("who", player.getName()).resolve("what", disguiseMeta.asComponent(playerLocale));
        source.sendMessage(MessageUtils.prefixes((CommandSender)source, morphSuccessMessage));
        BoundingBox box = BoundingBoxLookup.instance().getBoundboxOptional(result.state().getEntityType(), player.getLocation()).orElse(BoundingBox.of((Block)player.getLocation().getBlock()));
        double cX = cZ = box.getWidthX();
        double cY = box.getHeight();
        this.spawnCloudParticle(player, player.getLocation(), cX, cY, cZ);
        player.getWorld().playSound(player.getLocation(), Sound.UI_LOOM_TAKE_RESULT, SoundCategory.PLAYERS, 1.0f, 1.0f);
        DisguiseState newState = result.state();
        PropertyHandler propertyHandler = newState.disguisePropertyHandler();
        AbstractProperties<?> properties = propertyHandler.bindingProperties();
        if (properties != null) {
            propertyHandler.hookOnPropertyWrite((property, value) -> {
                if (newState.disposed()) {
                    return;
                }
                if (!properties.equals(propertyHandler.bindingProperties())) {
                    return;
                }
                Player pl = player.isConnected() ? player : Bukkit.getPlayer((UUID)player.getUniqueId());
                ConcurrentHashMap<String, String> diffMap = new ConcurrentHashMap<String, String>();
                try {
                    diffMap.put(property.id(), property.forValue(value));
                }
                catch (ParseErrorException e) {
                    this.logger.error("Can't generate output from value", (Throwable)e);
                    return;
                }
                this.clientHandler.sendCommand(pl, (AbstractS2CCommand<?>)new S2CUpdatePropertiesCommand(diffMap));
            });
        }
        if (isClientPlayer = this.clientHandler.clientConnected(player)) {
            if (!playerOptions.shownClientSkillHint) {
                player.sendMessage(MessageUtils.prefixes((CommandSender)player, HintStrings.clientSkillString()));
                playerOptions.shownClientSkillHint = true;
            }
        } else if (this.clientHandler.clientInitialized(player) && !playerOptions.shownDisplayToSelfHint) {
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, HintStrings.morphVisibleAfterCommandString()));
            playerOptions.shownDisplayToSelfHint = true;
        }
    }

    public S2CSyncAdminRevealCommand genMapCommand() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (DisguiseState disguiseState : this.activeDisguises) {
            Player player = disguiseState.getPlayer();
            map.put(player.getEntityId(), player.getName());
        }
        return new S2CSyncAdminRevealCommand(map);
    }

    public boolean disguiseDisabled(String key) {
        if (this.bannedDisguises.contains(key)) {
            return true;
        }
        String[] splitKey = key.split(":", 2);
        if (splitKey.length == 0) {
            return false;
        }
        return this.bannedDisguises.contains(splitKey[0] + ":@default");
    }

    public void refreshClientState(DisguiseState state) {
        Player player = state.getPlayer();
        this.clientHandler.updateCurrentIdentifier(player, state.getDisguiseIdentifier());
        PlayerSession clientSession = this.clientHandler.getSession(player);
        if (clientSession != null && clientSession.apiVersion < Constants.ApiLevel.NETWORK_DISGUISE_PROPERTIES.protocolVersion) {
            this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetSNbtCommand(state.getCulledNbtString()));
        } else {
            this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CUpdatePropertiesCommand(state.disguisePropertyHandler().toNetworkProperties()));
        }
        state.applyCooldownToClient();
        state.getSkill().applyToClient(state);
        state.getAbilityUpdater().getRegisteredAbilities().forEach(a -> a.onClientInit(state));
        DisguiseProvider provider = state.getProvider();
        provider.getInitialSyncCommands(state).forEach(c -> this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)c));
        List<String> availableAnimations = provider.getAnimationProvider().getAnimationSetFor(state.getDisguiseIdentifier()).getAvailableAnimationsForClient();
        this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetAvailableAnimationsCommand(availableAnimations));
        if (state.haveProfile()) {
            this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetProfileCommand(state.getProfileNbtString()));
        }
        this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetDisplayingFakeEquipCommand(state.showingDisguisedItems()));
    }

    public void unMorphAll(boolean ignoreOffline) {
        ObjectArrayList players = new ObjectArrayList(this.activeDisguises);
        players.forEach(i -> {
            if (ignoreOffline && !i.getPlayer().isOnline()) {
                return;
            }
            this.unMorph((CommandSender)i.getPlayer(), i.getPlayer(), true, true);
        });
    }

    public void unMorph(Player player) {
        this.unMorph((CommandSender)player, player, false, false);
    }

    public void unMorph(Player player, boolean bypassPermission) {
        this.unMorph((CommandSender)player, player, bypassPermission, false);
    }

    public void unMorph(@Nullable CommandSender source, Player player, boolean bypassPermission, boolean forceUnmorph) {
        NilCommandSource nilCommandSource = source = source == null ? MorphManager.nilCommandSource : source;
        if (!bypassPermission && !player.hasPermission("feathermorph.unmorph")) {
            source.sendMessage(MessageUtils.prefixes((CommandSender)player, CommandStrings.noPermissionMessage()));
            return;
        }
        DisguiseState state = this.activeDisguises.stream().filter(s -> s.getPlayer().getUniqueId().equals(player.getUniqueId())).findFirst().orElse(null);
        if (state == null) {
            return;
        }
        boolean earlyEventPassed = new PlayerUnMorphEarlyEvent(player, state, forceUnmorph).callEvent();
        if (!earlyEventPassed && !forceUnmorph) {
            source.sendMessage(MessageUtils.prefixes(source, MorphStrings.operationCancelledString()));
            return;
        }
        state.dispose();
        if (player.isConnected()) {
            this.spawnCloudParticle(player, player.getLocation(), player.getWidth(), player.getHeight(), player.getWidth());
            player.getWorld().playSound(player.getLocation(), Sound.UI_LOOM_TAKE_RESULT, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        this.activeDisguises.remove(state);
        this.updateLastPlayerMorphOperationTime(player);
        state.setBossbar(null);
        this.clientHandler.updateCurrentIdentifier(player, null);
        float revLevel = this.revealingHandler.getRevealingState(player).getBaseValue();
        this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetMobRevealCommand(revLevel));
        source.sendMessage(MessageUtils.prefixes((CommandSender)player, MorphStrings.unMorphSuccessString().withLocale(MessageUtils.getLocale(player))));
        player.sendActionBar((Component)Component.empty());
        this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetAvailableAnimationsCommand(List.of()));
        new PlayerUnMorphEvent(player).callEvent();
        this.modNetworkingHelper.sendCommandToRevealablePlayers(new S2CRemoveAdminRevealCommand(player.getEntityId()));
        state.dispose();
    }

    public void spawnCloudParticle(Player player, Location location, double collX, double collY, double collZ) {
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        location.setY(location.getY() + collY / 2.0);
        double particleScale = Math.max(1.0, collX * collY * collZ / 15.0);
        player.getWorld().spawnParticle(Particle.CLOUD, location, (int)(25.0 * particleScale), collX * 0.6, collY / 4.0, collZ * 0.6, particleScale >= 10.0 ? 0.2 : 0.05);
    }

    public boolean clientViewAvailable(Player player) {
        DisguiseState state = this.getDisguiseStateFor(player);
        PlayerOptions<Player> playerOption = this.clientHandler.getPlayerOption(player, true);
        if (state == null) {
            return playerOption.isClientSideSelfView();
        }
        return playerOption.isClientSideSelfView() && state.getProvider().validForClient(state);
    }

    public void setSelfDisguiseVisible(Player player, boolean val, boolean saveToConfig) {
        this.setSelfDisguiseVisible(player, val, saveToConfig, this.clientHandler.getPlayerOption(player, true).isClientSideSelfView(), false);
    }

    public void setSelfDisguiseVisible(Player player, boolean value, boolean saveToConfig, boolean dontSetServerSide, boolean noClientCommand) {
        DisguiseState state = this.getDisguiseStateFor(player);
        PlayerMeta config = this.data.getPlayerMeta((OfflinePlayer)player);
        if (state != null && !dontSetServerSide && !this.clientViewAvailable(player)) {
            state.setServerSideSelfVisible(value);
        }
        if (!noClientCommand) {
            this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetSelfViewingStatusCommand(value));
        }
        if (saveToConfig) {
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, value ? MorphStrings.selfVisibleOnString() : MorphStrings.selfVisibleOffString()));
            config.showDisguiseToSelf = value;
        }
    }

    @Nullable
    public DisguiseState getDisguiseStateFor(@Nullable Player player) {
        if (player == null) {
            return null;
        }
        return this.activeDisguises.stream().filter(i -> !i.disposed() && i.getPlayer().getUniqueId().equals(player.getUniqueId())).findFirst().orElse(null);
    }

    @Nullable
    public DisguiseState getDisguiseStateFor(@Nullable Entity entity) {
        if (!(entity instanceof Player)) {
            return null;
        }
        Player player = (Player)entity;
        return this.getDisguiseStateFor(player);
    }

    public void onPluginDisable() {
        this.getActiveDisguises().forEach(s -> {
            Player player = s.getPlayer();
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, MorphStrings.resetString()));
            if (!player.isOnline()) {
                this.offlineStorage.pushDisguiseState((DisguiseState)s);
            }
        });
        this.unMorphAll(false);
        this.saveConfiguration();
        this.offlineStorage.saveConfiguration();
        providers.clear();
    }

    public OfflineDisguiseState getOfflineState(Player player) {
        return this.offlineStorage.popDisguiseState(player.getUniqueId());
    }

    public List<OfflineDisguiseState> getAvaliableOfflineStates() {
        return this.offlineStorage.getAvaliableDisguiseStates();
    }

    public boolean disguiseFromState(DisguiseState state) {
        DisguiseMeta meta = this.getDisguiseMeta(state.getDisguiseIdentifier());
        DisguiseBuildResult result = DisguiseBuildResult.of(state, state.getProvider(), meta);
        PlayerMeta playerMeta = this.getPlayerMeta((OfflinePlayer)state.getPlayer());
        MorphParameters parameters = MorphParameters.create(state.getPlayer(), state.getDisguiseIdentifier());
        if (this.prepareDisguiseMeta(parameters) == null) {
            return false;
        }
        try {
            this.buildDisguise(result, parameters, playerMeta);
        }
        catch (Throwable ignored) {
            return false;
        }
        if (!this.applyDisguise(parameters, state, meta, playerMeta)) {
            return false;
        }
        this.afterDisguise(result, parameters, playerMeta);
        return true;
    }

    public OfflineDisguiseResult disguiseFromOfflineState(Player player, OfflineDisguiseState offlineState) {
        try {
            if (!player.getUniqueId().equals(offlineState.playerUUID)) {
                this.logger.error("OfflineState UUID mismatch: %s <-> %s".formatted(player.getUniqueId(), offlineState.playerUUID));
                return OfflineDisguiseResult.FAIL;
            }
            String key = offlineState.disguiseID;
            if (this.disguiseDisabled(key) || !this.getPlayerMeta((OfflinePlayer)player).getUnlockedDisguiseIdentifiers().contains(key)) {
                return OfflineDisguiseResult.FAIL;
            }
            if (DisguiseTypes.fromId(key) == DisguiseTypes.UNKNOWN) {
                return OfflineDisguiseResult.FAIL;
            }
            DisguiseProvider provider = MorphManager.getProvider(DisguiseTypes.fromId(key).getNameSpace());
            DisguiseState state = DisguiseStateGenerator.fromOfflineState(offlineState, this.clientHandler.getPlayerOption(player, true), this.getPlayerMeta((OfflinePlayer)player), this.skillManager, provider.getPreferredBackend());
            if (state != null) {
                this.disguiseFromState(state);
                this.modNetworkingHelper.sendCommandToRevealablePlayers(this.modNetworkingHelper.genPartialMapCommand(state));
                new PlayerDisguisedFromOfflineStateEvent(player, state).callEvent();
                return OfflineDisguiseResult.SUCCESS;
            }
            if (this.morph((CommandSender)player, player, key, null)) {
                DisguiseState newState = this.getDisguiseStateFor(player);
                if (newState != null) {
                    new PlayerDisguisedFromOfflineStateEvent(player, newState).callEvent();
                }
                return OfflineDisguiseResult.LIMITED;
            }
            return OfflineDisguiseResult.FAIL;
        }
        catch (Throwable t) {
            this.logger.error("Unable to recover disguise from OfflineState", t);
            return OfflineDisguiseResult.FAIL;
        }
    }

    @Override
    @Nullable
    public DisguiseMeta getDisguiseMeta(String rawString) {
        return this.data.getDisguiseMeta(rawString);
    }

    @Override
    public List<DisguiseMeta> getAvaliableDisguisesFor(Player player) {
        ObjectArrayList avail = this.data.getAvaliableDisguisesFor(player);
        return avail == null ? new ObjectArrayList() : avail;
    }

    @Override
    public boolean grantMorphToPlayer(Player player, String disguiseIdentifier) {
        boolean success = this.data.grantMorphToPlayer(player, disguiseIdentifier);
        if (!success) {
            return false;
        }
        this.clientHandler.sendDiff(List.of(disguiseIdentifier), null, player);
        this.multiInstanceService.notifyDisguiseMetaChange(player.getUniqueId(), Operation.ADD_IF_ABSENT, disguiseIdentifier);
        PlayerMeta config = this.data.getPlayerMeta((OfflinePlayer)player);
        String locale = MessageUtils.getLocale(player);
        DisguiseMeta meta = this.data.getDisguiseMeta(disguiseIdentifier);
        if (meta == null) {
            return false;
        }
        Component message = MessageUtils.prefixes((CommandSender)player, MorphStrings.morphUnlockedString().withLocale(locale).resolve("what", meta.asComponent(locale)));
        player.sendMessage(message);
        player.getWorld().spawnParticle(Particle.TRIAL_SPAWNER_DETECTION_OMINOUS, player.getLocation(), 100, 0.8, 0.8, 0.8, 0.05);
        if (this.clientHandler.clientConnected(player)) {
            if (!config.shownMorphClientHint) {
                player.sendMessage(MessageUtils.prefixes((CommandSender)player, HintStrings.firstGrantClientHintString()));
                config.shownMorphClientHint = true;
            }
        } else if (!config.shownMorphHint) {
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, HintStrings.firstGrantHintString()));
            config.shownMorphHint = true;
        }
        return success;
    }

    @Override
    public boolean revokeMorphFromPlayer(Player player, String disguiseIdentifier) {
        boolean success = this.data.revokeMorphFromPlayer(player, disguiseIdentifier);
        if (success) {
            this.clientHandler.sendDiff(null, List.of(disguiseIdentifier), player);
            this.multiInstanceService.notifyDisguiseMetaChange(player.getUniqueId(), Operation.REMOVE, disguiseIdentifier);
            String locale = MessageUtils.getLocale(player);
            DisguiseMeta meta = this.data.getDisguiseMeta(disguiseIdentifier);
            assert (meta != null);
            Component message = MorphStrings.morphLockedString().resolve("what", meta.asComponent(locale)).toComponent(locale);
            player.sendMessage(message);
            DisguiseState disguiseState = this.getDisguiseStateFor(player);
            if (disguiseState != null && disguiseState.getDisguiseIdentifier().equalsIgnoreCase(disguiseIdentifier)) {
                this.unMorph(player, true);
            }
        }
        return success;
    }

    @Override
    @NotNull
    public PlayerMeta getPlayerMeta(OfflinePlayer player) {
        return this.data.getPlayerMeta(player);
    }

    public void refreshDisguiseUnlockStateToAllPlayers() {
        this.featherMorph().getPlatform().onlinePlayersNative().forEach(p -> this.clientHandler.refreshPlayerClientMorphs(this.getPlayerMeta((OfflinePlayer)p).getUnlockedDisguiseIdentifiers(), (Player)p));
    }

    @Override
    public boolean reloadConfiguration() {
        ObjectArrayList stateToOfflineStore = new ObjectArrayList();
        this.activeDisguises.forEach(s -> {
            if (!s.getPlayer().isOnline()) {
                stateToOfflineStore.add(s);
            }
        });
        this.activeDisguises.removeAll((Collection<?>)stateToOfflineStore);
        List<DisguiseState> stateToRecover = this.getActiveDisguises();
        stateToRecover = stateToRecover.stream().map(oldState -> oldState.createCopy(oldState.getPlayer())).toList();
        this.unMorphAll(false);
        boolean success = this.data.reloadConfiguration() && this.offlineStorage.reloadConfiguration();
        stateToOfflineStore.forEach(this.offlineStorage::pushDisguiseState);
        stateToRecover.forEach(s -> {
            Player player = s.getPlayer();
            this.scheduleOn((Entity)player, () -> {
                MorphParameters parameter = MorphParameters.create(player, s.getDisguiseIdentifier());
                if (this.prepareDisguiseMeta(parameter) == null) {
                    return;
                }
                if (this.disguiseFromState((DisguiseState)s)) {
                    this.refreshClientState((DisguiseState)s);
                    player.sendMessage(MessageUtils.prefixes((CommandSender)player, MorphStrings.recoverString()));
                } else {
                    this.unMorph((CommandSender)nilCommandSource, player, true, true);
                }
            });
        });
        this.refreshDisguiseUnlockStateToAllPlayers();
        return success;
    }

    @Override
    public boolean saveConfiguration() {
        return this.data.saveConfiguration() && this.offlineStorage.saveConfiguration();
    }

    @Override
    public void shouldLoadAllData(boolean shouldLoadAllData) {
        this.data.shouldLoadAllData(shouldLoadAllData);
    }

    @Override
    public List<PlayerMeta> listAll() {
        return this.data.listAll();
    }

    @ApiStatus.Internal
    public List<PlayerMeta> listAllPlayerMeta() {
        this.data.shouldLoadAllData(true);
        return this.data.listAll();
    }
}

