/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;

public interface ISkillAbilityOptionHandler<O extends ISkillAbilityOption> {
    public void writeOption(O var1, @NotNull Map<String, Object> var2);

    public Class<O> getOptionClass();

    default public boolean acceptNullableOptions() {
        return false;
    }

    default public O readOptionNullable(@Nullable Map<String, Object> gsonMap) throws NullPointerException, UnsupportedOperationException, ParseErrorException {
        if (gsonMap == null) {
            if (this.acceptNullableOptions()) {
                throw new UnsupportedOperationException("Method not implemented");
            }
            throw new NullPointerException(this.getClass().getSimpleName() + " Requires a non-null gsonMap, but got Null!");
        }
        return this.readOption(gsonMap);
    }

    @NotNull
    public O readOption(@NotNull Map<String, Object> var1) throws ParseErrorException;

    @Nullable
    default public <T> T utilGetTypedOrNull(String key, Map<String, Object> gsonMap, Class<T> expectedType) throws ParseErrorException {
        T val = gsonMap.getOrDefault(key, null);
        if (val == null) {
            return null;
        }
        if (expectedType.isInstance(val)) {
            return val;
        }
        throw new ParseErrorException(this.getClass().getSimpleName(), "Input key '%s' is not a instance of expected type '%s'".formatted(key, expectedType));
    }

    default public <T> T utilGetTypedOrThrow(String key, Map<String, Object> gsonMap, Class<T> expectedType) throws ParseErrorException {
        T val = this.utilGetTypedOrNull(key, gsonMap, expectedType);
        if (val == null) {
            throw new ParseErrorException(this.getClass().getSimpleName(), "Key '%s' not present in the option map".formatted(key));
        }
        return val;
    }
}

