/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.options;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;

public class FlyOption
implements ISkillAbilityOption {
    public static final FlyOptionHandler OPTION_HANDLER = new FlyOptionHandler();
    private final float flyingSpeed;
    private final int minimumHunger;

    public FlyOption(float speed) {
        this(speed, 6);
    }

    public FlyOption(float speed, int minimumHunger) {
        this.flyingSpeed = speed;
        this.minimumHunger = minimumHunger;
    }

    public float getFlyingSpeed() {
        return this.flyingSpeed;
    }

    public int getMinimumHunger() {
        return this.minimumHunger;
    }

    @Override
    public boolean isValid() {
        return !Float.isNaN(this.flyingSpeed);
    }

    public static class FlyOptionHandler
    implements ISkillAbilityOptionHandler<FlyOption> {
        @Override
        public Class<FlyOption> getOptionClass() {
            return FlyOption.class;
        }

        @Override
        public void writeOption(FlyOption option, @NotNull Map<String, Object> gsonMap) {
            gsonMap.put("fly_speed", Float.valueOf(option.getFlyingSpeed()));
            gsonMap.put("minimum_hunger", option.getMinimumHunger());
        }

        @Override
        @NotNull
        public FlyOption readOption(@NotNull Map<String, Object> gsonMap) throws ParseErrorException {
            float flySpeed = this.utilGetTypedOrThrow("fly_speed", gsonMap, Number.class).floatValue();
            int minimumHunger = this.utilGetTypedOrThrow("minimum_hunger", gsonMap, Number.class).intValue();
            String clazzSimpleName = this.getClass().getSimpleName();
            if (!Float.isFinite(flySpeed)) {
                throw new ParseErrorException(clazzSimpleName, "Non-Finite fly speed");
            }
            return new FlyOption(flySpeed, minimumHunger);
        }
    }
}

