/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.api.networking;

import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.api.FeatherMorphAPI;
import xyz.nifeather.morph.network.server.MorphClientHandler;

public class PlayerConnection {
    private final FeatherMorphAPI api;
    private final MorphClientHandler clientHandler;

    public PlayerConnection(FeatherMorphAPI api) {
        this.api = api;
        this.clientHandler = api.directAccess().clientHandler();
    }

    public boolean playerLoggedIn(Player player) {
        return this.clientHandler.isPlayerInitialized(player);
    }

    public int getPlayerAPIVersion(Player player) {
        return this.clientHandler.getPlayerVersion(player);
    }

    public void disconnectPlayer(Player player, @Nullable Exception reason) {
        this.clientHandler.disconnect(player, reason);
    }

    public int getTargetAPI() {
        return this.clientHandler.targetApiVersion;
    }

    public CompletableFuture<Player> getPlayerChannelPendingFuture(Player player) {
        return this.clientHandler.getPlayerChannelPendingFuture(player);
    }

    public CompletableFuture<Player> getPlayerLoginPendingFuture(Player player) {
        return this.clientHandler.getPlayerLoginPendingFuture(player);
    }

    public CompletableFuture<Player> getPlayerConnectionFuture(Player player) {
        return this.clientHandler.getPlayerConnectionFuture(player);
    }
}

