/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network;

import com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import com.github.retrooper.packetevents.protocol.player.Equipment;
import com.github.retrooper.packetevents.protocol.player.EquipmentSlot;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.nifeather.morph.FeatherMorphMain;

public class ProtocolEquipment {
    public static final com.github.retrooper.packetevents.protocol.item.ItemStack peAir = new ItemStack.Builder().type(ItemTypes.AIR).build();

    public static ObjectArrayList<Equipment> toPEEquipmentList(EntityEquipment equipment) {
        ObjectArrayList list = new ObjectArrayList();
        for (org.bukkit.inventory.EquipmentSlot bukkitSlot : org.bukkit.inventory.EquipmentSlot.values()) {
            Equipment packetEquipment = ProtocolEquipment.toEquipment(equipment, bukkitSlot);
            if (packetEquipment == null) continue;
            list.add((Object)packetEquipment);
        }
        return list;
    }

    private static EquipmentSlot toPESlot(org.bukkit.inventory.EquipmentSlot bukkitSlot) {
        return switch (bukkitSlot) {
            default -> throw new MatchException(null, null);
            case org.bukkit.inventory.EquipmentSlot.HAND -> EquipmentSlot.MAIN_HAND;
            case org.bukkit.inventory.EquipmentSlot.OFF_HAND -> EquipmentSlot.OFF_HAND;
            case org.bukkit.inventory.EquipmentSlot.HEAD -> EquipmentSlot.HELMET;
            case org.bukkit.inventory.EquipmentSlot.CHEST -> EquipmentSlot.CHEST_PLATE;
            case org.bukkit.inventory.EquipmentSlot.LEGS -> EquipmentSlot.LEGGINGS;
            case org.bukkit.inventory.EquipmentSlot.FEET -> EquipmentSlot.BOOTS;
            case org.bukkit.inventory.EquipmentSlot.BODY -> EquipmentSlot.BODY;
            case org.bukkit.inventory.EquipmentSlot.SADDLE -> EquipmentSlot.SADDLE;
        };
    }

    @Nullable
    private static Equipment toEquipment(EntityEquipment equipment, org.bukkit.inventory.EquipmentSlot bukkitSlot) {
        if (bukkitSlot == org.bukkit.inventory.EquipmentSlot.SADDLE || bukkitSlot == org.bukkit.inventory.EquipmentSlot.BODY) {
            return null;
        }
        try {
            ItemStack bukkitItem = equipment.getItem(bukkitSlot);
            com.github.retrooper.packetevents.protocol.item.ItemStack peItem = SpigotConversionUtil.fromBukkitItemStack((ItemStack)bukkitItem);
            return new Equipment(ProtocolEquipment.toPESlot(bukkitSlot), peItem);
        }
        catch (Throwable t) {
            Logger logger = FeatherMorphMain.getInstance().getSLF4JLogger();
            logger.warn("Can't generate equipment pair", t);
            return new Equipment(EquipmentSlot.BOOTS, peAir);
        }
    }
}

