/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.values;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataType;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.values.SingleValue;

public abstract class AbstractValues {
    private int currentIndex = 0;
    protected final Logger logger = FeatherMorphMain.getInstance().getSLF4JLogger();
    protected final List<SingleValue<?>> values = new CopyOnWriteArrayList();

    protected <X> SingleValue<X> createSingle(String name, X val, EntityDataType<X> dataType) {
        if (val == null) {
            throw new IllegalArgumentException("May not pass a null value to getIndex()");
        }
        SingleValue<X> sv = SingleValue.of(name, this.currentIndex, val, dataType);
        ++this.currentIndex;
        return sv;
    }

    protected void registerSingle(SingleValue<?> ... value) {
        for (SingleValue<?> singleValue : value) {
            this.registerSingle(singleValue);
        }
    }

    protected void registerSingle(SingleValue<?> value) {
        SingleValue duplicateValue = this.values.stream().filter(sv -> sv.index() == value.index()).findFirst().orElse(null);
        if (duplicateValue != null) {
            throw new IllegalArgumentException("Already contains a value with index '%s'".formatted(value.index()));
        }
        this.values.add(value);
    }

    public List<SingleValue<?>> getValues() {
        return this.values;
    }
}

