/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import com.github.retrooper.packetevents.protocol.entity.armadillo.ArmadilloState;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;

public class ArmadilloWatcher
extends LivingEntityWatcher {
    public ArmadilloWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.ARMADILLO);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.ARMADILLO);
    }

    @Override
    protected <X> void onEntryWrite(CustomEntry<X> entry, X oldVal, X newVal) {
        super.onEntryWrite(entry, oldVal, newVal);
        if (entry.equals(CustomEntries.ANIMATION)) {
            String animId = newVal.toString();
            Player player = this.getBindingPlayer();
            World world = player.getWorld();
            switch (animId) {
                case "rollup_rolling": {
                    this.writePersistent(ValueIndex.ARMADILLO.STATE, ArmadilloState.ROLLING);
                    world.playSound(player.getLocation(), Sound.ENTITY_ARMADILLO_ROLL, 1.0f, 1.0f);
                    break;
                }
                case "rollup_scared": {
                    this.writePersistent(ValueIndex.ARMADILLO.STATE, ArmadilloState.SCARED);
                    world.playSound(player.getLocation(), Sound.ENTITY_ARMADILLO_LAND, 1.0f, 1.0f);
                    break;
                }
                case "rollup_unrolling": {
                    this.writePersistent(ValueIndex.ARMADILLO.STATE, ArmadilloState.UNROLLING);
                    world.playSound(player.getLocation(), Sound.ENTITY_ARMADILLO_UNROLL_START, 1.0f, 1.0f);
                    break;
                }
                case "rollup_idle": 
                case "reset": {
                    this.writePersistent(ValueIndex.ARMADILLO.STATE, ArmadilloState.IDLE);
                    if (!animId.equals("rollup_idle")) break;
                    world.playSound(player.getLocation(), Sound.ENTITY_ARMADILLO_UNROLL_FINISH, 1.0f, 1.0f);
                }
            }
        }
    }
}

