/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import com.github.retrooper.packetevents.protocol.attribute.Attributes;
import com.github.retrooper.packetevents.protocol.particle.Particle;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleColorData;
import com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectObjectMutablePair;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.values.basetypes.LivingEntityValues;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.EntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.BuildFailedException;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;
import xyz.nifeather.morph.utilities.NmsUtils;

public class LivingEntityWatcher
extends EntityWatcher {
    private final Pair<Player, EquipmentSlot> handPair = new ObjectObjectMutablePair(null, null);

    public LivingEntityWatcher(Player bindingPlayer, EntityType entityType) {
        super(bindingPlayer, entityType);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.BASE_LIVING);
    }

    public void onPlayerStartUsingItem(PlayerInteractEvent e) {
        if (!this.isPlayerOnline()) {
            return;
        }
        if (!this.getBindingPlayer().equals((Object)e.getPlayer())) {
            return;
        }
        this.handPair.left((Object)e.getPlayer());
        this.handPair.right((Object)e.getHand());
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        BaseLivingEntityProperties properties = DisguiseProperties.INSTANCE.getOrThrow(BaseLivingEntityProperties.class);
        if (property.equals(properties.CUSTOM_NAME)) {
            TextComponent textComponent;
            if (value instanceof Component) {
                Component component1 = (Component)value;
                textComponent = component1;
            } else {
                textComponent = Component.empty();
            }
            TextComponent component = textComponent;
            this.writePersistent(ValueIndex.BASE_LIVING.CUSTOM_NAME, component.equals((Object)Component.empty()) ? Optional.empty() : Optional.of(component));
        } else if (property.equals(properties.CUSTOM_NAME_VISIBLE)) {
            Boolean b;
            Boolean bool = value instanceof Boolean ? (b = (Boolean)value) : Boolean.valueOf(Boolean.parseBoolean(value.toString()));
            this.writePersistent(ValueIndex.BASE_LIVING.CUSTOM_NAME_VISIBLE, bool);
        } else if (property.equals(properties.STUCKED_ARROWS)) {
            int count = (Integer)value;
            this.writePersistent(ValueIndex.BASE_LIVING.STUCKED_ARROWS, count);
        }
        super.onPropertyWrite(property, value);
    }

    protected WrapperPlayServerUpdateAttributes buildAttributePacket() {
        Player player = this.getBindingPlayer();
        ObjectArrayList attributeProperties = new ObjectArrayList();
        ServerPlayer nmsPlayer = NmsRecord.ofPlayer(player);
        Object attributes = this.getEntityType() == EntityType.PLAYER ? new ObjectArrayList(nmsPlayer.getAttributes().getSyncableAttributes()) : NmsUtils.getValidAttributes(this.getEntityType(), nmsPlayer.getAttributes());
        attributes.forEach(arg_0 -> this.lambda$buildAttributePacket$0((List)attributeProperties, arg_0));
        return new WrapperPlayServerUpdateAttributes(player.getEntityId(), (List)attributeProperties);
    }

    protected WrapperPlayServerUpdateAttributes.PropertyModifier.Operation fromNMSAttributeOperation(AttributeModifier.Operation nmsOperation) {
        return switch (nmsOperation) {
            default -> throw new MatchException(null, null);
            case AttributeModifier.Operation.ADD_VALUE -> WrapperPlayServerUpdateAttributes.PropertyModifier.Operation.ADDITION;
            case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> WrapperPlayServerUpdateAttributes.PropertyModifier.Operation.MULTIPLY_BASE;
            case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> WrapperPlayServerUpdateAttributes.PropertyModifier.Operation.MULTIPLY_TOTAL;
        };
    }

    @Override
    public List<PacketWrapper<?>> buildSpawnPackets() throws BuildFailedException {
        ObjectArrayList packets = new ObjectArrayList();
        List<PacketWrapper<?>> entityPackets = super.buildSpawnPackets();
        packets.addAll(entityPackets);
        packets.add((Object)this.buildAttributePacket());
        return packets;
    }

    @Override
    protected void doSync() {
        super.doSync();
        Player player = this.getBindingPlayer();
        ServerPlayer nmsPlayer = NmsRecord.ofPlayer(player);
        LivingEntityValues values = ValueIndex.BASE_LIVING;
        this.writeTemp(values.HEALTH, Float.valueOf((float)player.getHealth()));
        int flagBit = 0;
        if (nmsPlayer.isUsingItem()) {
            boolean isOffhand;
            flagBit |= 1;
            EquipmentSlot handInUse = (EquipmentSlot)this.handPair.right();
            if (handInUse == null) {
                InteractionHand nmsHand = nmsPlayer.getUsedItemHand();
                handInUse = nmsHand == InteractionHand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
            }
            boolean bl = isOffhand = handInUse == EquipmentSlot.OFF_HAND;
            if (isOffhand) {
                flagBit |= 2;
            }
        }
        if (player.isRiptiding()) {
            flagBit |= 4;
        }
        this.writeTemp(values.LIVING_FLAGS, (byte)flagBit);
        ObjectArrayList colors = new ObjectArrayList();
        boolean hasAmbient = false;
        for (Object effect : player.getActivePotionEffects()) {
            if (effect.hasParticles()) {
                colors.add(effect.getType().getColor());
            }
            hasAmbient = hasAmbient || effect.isAmbient();
        }
        ObjectArrayList colorList = new ObjectArrayList();
        for (Color color : colors) {
            colorList.add((Object)new Particle(ParticleTypes.ENTITY_EFFECT, (ParticleData)new ParticleColorData(color.asRGB())));
        }
        this.writeTemp(values.POTION_COLOR, colorList);
        this.writeTemp(values.POTION_ISAMBIENT, hasAmbient);
        this.writeTemp(values.STUCKED_ARROWS, player.getArrowsInBody());
        this.writeTemp(values.BEE_STINGERS, player.getBeeStingersInBody());
        Optional<Object> bedPos = Optional.empty();
        if (player.isSleeping()) {
            Location bukkitPos = player.getBedLocation();
            bedPos = Optional.of(new Vector3i(bukkitPos.blockX(), bukkitPos.blockY(), bukkitPos.blockZ()));
        }
        this.writeTemp(values.BED_POS, bedPos);
    }

    private /* synthetic */ void lambda$buildAttributePacket$0(List attributeProperties, AttributeInstance instance) {
        net.minecraft.resources.ResourceLocation nmsAttribute = BuiltInRegistries.ATTRIBUTE.getKey((Object)((Attribute)instance.getAttribute().value()));
        if (nmsAttribute == null) {
            this.logger.warn("Unknown attribute from bukkit to NMS: " + String.valueOf(instance.getAttribute().value()));
            return;
        }
        String id = nmsAttribute.toString();
        com.github.retrooper.packetevents.protocol.attribute.Attribute packetAttribute = Attributes.getByName((String)id);
        if (packetAttribute == null) {
            this.logger.warn("Unknown attribute for packet: " + id);
            return;
        }
        ObjectArrayList modifiers = new ObjectArrayList();
        for (AttributeModifier modifier : instance.getModifiers()) {
            WrapperPlayServerUpdateAttributes.PropertyModifier packetModifier = new WrapperPlayServerUpdateAttributes.PropertyModifier(new ResourceLocation(modifier.id().toString()), UUID.randomUUID(), modifier.amount(), this.fromNMSAttributeOperation(modifier.operation()));
            modifiers.add(packetModifier);
        }
        WrapperPlayServerUpdateAttributes.Property property = new WrapperPlayServerUpdateAttributes.Property(packetAttribute, instance.getBaseValue(), (List)modifiers);
        attributeProperties.add(property);
    }
}

