/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.registries;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.RegisterParameters;
import xyz.nifeather.morph.backends.server.renderer.network.registries.WatcherIndex;

public class RenderRegistry
extends MorphPluginObject {
    private final Map<Object, Consumer<EventParameters>> onRegisterConsumers = new Object2ObjectOpenHashMap();
    private final Map<Object, Consumer<EventParameters>> unRegisterConsumers = new Object2ObjectOpenHashMap();
    private final Map<Object, Consumer<EventParameters>> onRegistryChangeConsumers = new Object2ObjectOpenHashMap();
    private final Map<UUID, SingleWatcher> watcherMap = new ConcurrentHashMap<UUID, SingleWatcher>();

    public void onRegistryChange(Object source, Consumer<EventParameters> consumer) {
        this.onRegistryChangeConsumers.put(source, consumer);
    }

    public void onRegister(Object source, Consumer<EventParameters> consumer) {
        this.onRegisterConsumers.put(source, consumer);
    }

    private void callRegister(Player player, SingleWatcher watcher) {
        EventParameters ep = new EventParameters(player, watcher);
        this.onRegisterConsumers.forEach((source, consumer) -> consumer.accept(ep));
    }

    public void onUnRegister(Object source, Consumer<EventParameters> consumer) {
        this.unRegisterConsumers.put(source, consumer);
    }

    private void callUnregister(@Nullable Player player, SingleWatcher watcher) {
        this.unRegisterConsumers.forEach((source, consumer) -> consumer.accept(new EventParameters(player, watcher)));
    }

    public List<SingleWatcher> getWatchers() {
        return new ObjectArrayList(this.watcherMap.values());
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public SingleWatcher getWatcher(Entity entity) {
        return this.getWatcher(entity.getUniqueId());
    }

    @Nullable
    public SingleWatcher getWatcher(UUID uuid) {
        return this.watcherMap.getOrDefault(uuid, null);
    }

    public void unregister(Player player) {
        this.unregister(player.getUniqueId());
    }

    @Nullable
    public SingleWatcher unregister(UUID uuid) {
        SingleWatcher watcher = this.watcherMap.remove(uuid);
        if (watcher == null) {
            return null;
        }
        this.callUnregister(Bukkit.getPlayer((UUID)uuid), watcher);
        watcher.setParentRegistry(null);
        watcher.dispose();
        return watcher;
    }

    public SingleWatcher register(@NotNull Player player, RegisterParameters registerParameters, Consumer<SingleWatcher> watcherConsumer) {
        SingleWatcher watcher = WatcherIndex.getInstance().getWatcherForType(player, registerParameters.entityType());
        watcher.markSilent(this);
        watcher.writeEntry(CustomEntries.DISGUISE_NAME, registerParameters.name());
        watcher.writeEntry(CustomEntries.SPAWN_ID, player.getEntityId());
        watcherConsumer.accept(watcher);
        this.registerWithWatcher(player.getUniqueId(), watcher);
        watcher.unmarkSilent(this);
        return watcher;
    }

    public void registerWithWatcher(@NotNull UUID uuid, @NotNull SingleWatcher watcher) {
        if (!watcher.getBindingPlayer().getUniqueId().equals(uuid)) {
            throw new IllegalArgumentException("Watcher UUID doesn't match with player's UUID!");
        }
        this.watcherMap.put(uuid, watcher);
        watcher.setParentRegistry(this);
        this.callRegister(Bukkit.getPlayer((UUID)uuid), watcher);
    }

    public void reset() {
        this.watcherMap.forEach((uuid, watcher) -> this.unregister((UUID)uuid));
        this.watcherMap.clear();
    }

    public record EventParameters(@Nullable Player player, SingleWatcher watcher) {
    }
}

