/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import java.io.File;
import java.time.Duration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.AnimationCommand;
import xyz.nifeather.morph.commands.DebugTestCommand;
import xyz.nifeather.morph.commands.MorphCommand;
import xyz.nifeather.morph.commands.MorphPlayerCommand;
import xyz.nifeather.morph.commands.MorphPluginCommand;
import xyz.nifeather.morph.commands.RequestCommand;
import xyz.nifeather.morph.commands.UnMorphCommand;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;

public class MorphCommandManager
extends MorphPluginObject {
    private final List<IConvertibleBrigadier> commands = List.of(new MorphCommand(), new MorphPlayerCommand(), new UnMorphCommand(), new RequestCommand(), new MorphPluginCommand(), new AnimationCommand());

    public List<IConvertibleBrigadier> commands() {
        return this.commands;
    }

    public void register(ReloadableRegistrarEvent<@NotNull Commands> event) {
        Commands registrar = (Commands)event.registrar();
        for (IConvertibleBrigadier brigadierConvertable : this.commands) {
            brigadierConvertable.register(registrar);
        }
        File cmdDebugFile = new File(FeatherMorphMain.getInstance().getDataFolder(), "cmd_debug.txt");
        if (cmdDebugFile.exists()) {
            this.logger.error("- x - x - x - x - x - x - x - x - x - x - x - x -");
            this.logger.error("MAY I HAVE YOUR ATTENTION PLEASE!");
            this.logger.error("");
            this.logger.error("Debug commands are enabled, these commands are only meant to do debugging stuffs!");
            this.logger.error("These commands may have bugs, or incomplete permission check that allows everyone to execute, even crash the server!");
            this.logger.error("Please make sure that you REALLY need these commands; if not, please remove file [%s] IMMEDIATELY and RESTART THE SERVER!".formatted(cmdDebugFile.getAbsolutePath()));
            this.logger.error("");
            this.logger.error("- x - x - x - x - x - x - x - x - x - x - x - x -");
            try {
                Thread.sleep(Duration.ofSeconds(3L));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            new DebugTestCommand().register(registrar);
        }
    }
}

