/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.commands.brigadier.BrigadierCommand;
import xyz.nifeather.morph.messages.CommandStrings;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.utilities.ItemUtils;

public class MakeSkillItemSubCommand
extends BrigadierCommand {
    @Override
    @NotNull
    public String name() {
        return "make_disguise_tool";
    }

    @Override
    @Nullable
    public String getPermissionRequirement() {
        return "feathermorph.make_disguise_tool";
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return new FormattableMessage(this.plugin, "make selected a disguise tool");
    }

    @Override
    public boolean register(Commands dispatcher) {
        dispatcher.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission)).executes(this::executes)).build());
        return super.register(dispatcher);
    }

    public int executes(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageUtils.prefixes(sender, CommandStrings.noPermissionMessage()));
            return 1;
        }
        Player player = (Player)sender;
        ItemStack item = player.getEquipment().getItemInMainHand();
        if (item.isEmpty() || item.getType().isAir()) {
            sender.sendMessage(MessageUtils.prefixes(sender, CommandStrings.illegalArgumentString().resolve("detail", "air... :(")));
            return 1;
        }
        item = ItemUtils.buildDisguiseToolFrom(item);
        player.getEquipment().setItemInMainHand(item);
        sender.sendMessage(MessageUtils.prefixes(sender, CommandStrings.success()));
        return 1;
    }
}

