/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin.management;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;
import xyz.nifeather.morph.commands.brigadier.arguments.DisguiseIdentifierArgumentType;
import xyz.nifeather.morph.messages.HelpStrings;
import xyz.nifeather.morph.misc.MorphParameters;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class ForceMorphSubCommand
extends MorphPluginObject
implements IConvertibleBrigadier {
    @Resolved
    private MorphManager manager;

    @Override
    @NotNull
    public String name() {
        return "morph";
    }

    @Override
    @Nullable
    public String permission() {
        return "feathermorph.manage.morph";
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission)).then(Commands.argument((String)"who", (ArgumentType)ArgumentTypes.players()).then(Commands.argument((String)"as_what", (ArgumentType)DisguiseIdentifierArgumentType.ALL_AVAILABLE).executes(this::execute))));
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List players = (List)((PlayerSelectorArgumentResolver)context.getArgument("who", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)context.getSource());
        players.forEach(who -> {
            String targetName = DisguiseIdentifierArgumentType.getArgument(context, "as_what");
            CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
            if (!who.isOnline()) {
                return;
            }
            MorphParameters parameters = MorphParameters.create(who, targetName).setSource(commandSender).setForceExecute(true).setBypassAvailableCheck(true).setBypassPermission(true);
            this.manager.morph(parameters);
        });
        return 1;
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.manageUnmorphDescription();
    }
}

