/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin.management;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;
import xyz.nifeather.morph.commands.brigadier.arguments.DisguiseIdentifierArgumentType;
import xyz.nifeather.morph.messages.CommandStrings;
import xyz.nifeather.morph.messages.CommonStrings;
import xyz.nifeather.morph.messages.HelpStrings;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.MorphStrings;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.providers.disguise.DisguiseProvider;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class GrantDisguiseSubCommand
extends MorphPluginObject
implements IConvertibleBrigadier {
    @Resolved
    private MorphManager morphs;

    @Override
    @NotNull
    public String name() {
        return "grant";
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.manageGrantDescription();
    }

    @Override
    @Nullable
    public String permission() {
        return "feathermorph.manage.grant";
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission)).then(Commands.argument((String)"who", (ArgumentType)ArgumentTypes.players()).then(Commands.argument((String)"what", (ArgumentType)DisguiseIdentifierArgumentType.ALL_AVAILABLE).executes(this::execute))));
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List players = (List)((PlayerSelectorArgumentResolver)context.getArgument("who", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)context.getSource());
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        if (players.isEmpty()) {
            commandSender.sendMessage(MessageUtils.prefixes(commandSender, CommonStrings.playerNotFoundString()));
            return 1;
        }
        players.forEach(who -> {
            Object targetName = DisguiseIdentifierArgumentType.getArgument(context, "what");
            if (!who.isOnline()) {
                return;
            }
            if (!((String)targetName).contains(":")) {
                targetName = "minecraft:" + (String)targetName;
            }
            DisguiseProvider provider = MorphManager.getProvider((String)targetName);
            DisguiseTypes nameType = DisguiseTypes.fromId((String)targetName);
            if (nameType.toStrippedId((String)targetName).equals("@all")) {
                List<String> allDisg = provider.getAllAvailableDisguises();
                allDisg.forEach(id -> this.grantDisguise((Player)who, nameType.toId((String)id), commandSender));
                return;
            }
            if (!provider.isValid((String)targetName)) {
                commandSender.sendMessage(MessageUtils.prefixes(commandSender, MorphStrings.invalidIdentityString()));
                return;
            }
            this.grantDisguise((Player)who, (String)targetName, commandSender);
        });
        return 1;
    }

    private void grantDisguise(Player who, String targetName, CommandSender commandSender) {
        FormattableMessage msg = this.morphs.grantMorphToPlayer(who, targetName) ? CommandStrings.grantSuccessString() : CommandStrings.grantFailString();
        msg.resolve("what", (Component)Component.text((String)targetName)).resolve("who", who.getName());
        commandSender.sendMessage(MessageUtils.prefixes(commandSender, msg));
    }
}

