/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.events;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.craftbukkit.entity.CraftMob;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.api.events.gameplay.PlayerMorphEvent;
import xyz.nifeather.morph.api.events.gameplay.PlayerUnMorphEvent;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.events.PlayerTracker;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;

public class RevealingEventProcessor
extends MorphPluginObject
implements Listener {
    @Resolved(shouldSolveImmediately=true)
    private RevealingHandler handler;
    @Resolved(shouldSolveImmediately=true)
    private PlayerTracker tracker;
    private final Bindable<Boolean> doRevealing = new Bindable<Boolean>(true);

    @Initializer
    private void load(MorphConfigManager configManager) {
        configManager.bind(this.doRevealing, ConfigOption.REVEALING);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.handler.updateStatePlayerInstance(e.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (!e.hasBlock()) {
            return;
        }
        if (e.getClickedBlock() == null) {
            return;
        }
        if (!this.doRevealing.get().booleanValue()) {
            return;
        }
        if (!e.getClickedBlock().getType().isInteractable()) {
            return;
        }
        Player player = e.getPlayer();
        if (this.tracker.isDuplicatedRightClick(player)) {
            return;
        }
        RevealingHandler.RevealingState revealingState = this.handler.getRevealingState(player);
        if (revealingState.bindingState == null) {
            return;
        }
        if (revealingState.bindingState.getDisguiseType() == DisguiseTypes.PLAYER) {
            return;
        }
        revealingState.addBaseValue(0.4f);
    }

    @EventHandler
    public void onPlayerDeath(EntityDeathEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        RevealingHandler.RevealingState revState = this.handler.getRevealingState(player);
        revState.setBaseValue(0.0f);
    }

    @EventHandler
    public void onInteractEntity(PlayerInteractEntityEvent e) {
        if (!this.doRevealing.get().booleanValue()) {
            return;
        }
        RevealingHandler.RevealingState revState = this.handler.getRevealingState(e.getPlayer());
        if (revState.bindingState == null) {
            return;
        }
        if (revState.bindingState.getDisguiseType() == DisguiseTypes.PLAYER) {
            return;
        }
        revState.addBaseValue(0.4f);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent e) {
        if (!this.doRevealing.get().booleanValue()) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        RevealingHandler.RevealingState revState = this.handler.getRevealingState(player);
        if (revState.bindingState == null) {
            return;
        }
        if (revState.bindingState.getDisguiseType() == DisguiseTypes.PLAYER) {
            return;
        }
        revState.addBaseValue(1.5f);
    }

    @EventHandler
    public void onPlayerDamageEntities(EntityDamageByEntityEvent e) {
        if (!this.doRevealing.get().booleanValue()) {
            return;
        }
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        RevealingHandler.RevealingState revState = this.handler.getRevealingState(player);
        if (revState.bindingState == null) {
            return;
        }
        if (revState.bindingState.getDisguiseType() == DisguiseTypes.PLAYER) {
            return;
        }
        revState.addBaseValue(0.375f);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        if (!this.doRevealing.get().booleanValue()) {
            return;
        }
        RevealingHandler.RevealingState revealingState = this.handler.getRevealingState(e.getPlayer());
        if (revealingState.bindingState == null) {
            return;
        }
        if (revealingState.bindingState.getDisguiseType() == DisguiseTypes.PLAYER) {
            return;
        }
        revealingState.addBaseValue(0.45f);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        if (!this.doRevealing.get().booleanValue()) {
            return;
        }
        RevealingHandler.RevealingState revealingState = this.handler.getRevealingState(e.getPlayer());
        if (revealingState.bindingState == null) {
            return;
        }
        if (revealingState.bindingState.getDisguiseType() == DisguiseTypes.PLAYER) {
            return;
        }
        revealingState.addBaseValue(0.45f);
    }

    @EventHandler
    public void onPlayerMorph(PlayerMorphEvent e) {
        if (!this.doRevealing.get().booleanValue()) {
            return;
        }
        Player player = e.getPlayer();
        List mobsNearby = player.getNearbyEntities(16.0, 16.0, 16.0);
        ServerPlayer nmsPlayer = NmsRecord.ofPlayer(player);
        RevealingHandler.RevealingState revealingState = this.handler.getRevealingState(player);
        revealingState.bindingState = e.getState();
        if (revealingState.bindingState.getDisguiseType() == DisguiseTypes.PLAYER) {
            return;
        }
        revealingState.addBaseValue(RevealingHandler.RevealingLevel.SUSPECT.getValue() * 0.1f, true);
        if (!mobsNearby.isEmpty()) {
            for (Entity entity : mobsNearby) {
                CraftMob craftMob;
                if (!(entity instanceof CraftMob) || !nmsPlayer.equals((Object)(craftMob = (CraftMob)entity).getHandle().getTarget())) continue;
                float base = revealingState.getBaseValue();
                revealingState.setBaseValue(Math.max(base, (float)RevealingHandler.RevealingDiffs.ALREADY_TARGETED));
                break;
            }
        }
    }

    @EventHandler
    public void onPlayerUnmorph(PlayerUnMorphEvent e) {
        RevealingHandler.RevealingState revealingState = this.handler.getRevealingState(e.getPlayer());
        revealingState.bindingState = null;
    }
}

