/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.events.mirror.impl;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.level.GameType;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.events.PlayerTracker;
import xyz.nifeather.morph.events.mirror.ExecutorHub;
import xyz.nifeather.morph.events.mirror.impl.ChainedExecutor;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.storage.mirrorlogging.OperationType;

public class ByRangeExecutor
extends ChainedExecutor {
    public ByRangeExecutor(ExecutorHub executorHub) {
        super(executorHub);
    }

    @Override
    @Nullable
    protected Player findNextControllablePlayerFrom(Player source, List<Player> pendingChain) {
        int index = pendingChain.indexOf(source);
        if (index == -1 || index >= pendingChain.size()) {
            return null;
        }
        return pendingChain.get(index + 1);
    }

    @Override
    protected List<Player> buildSimulateChain(Player source) {
        int controlDistance;
        String targetName = this.getTargetControlFor(source);
        if (targetName == null) {
            targetName = source.getName();
        }
        if ((controlDistance = this.executorHub.getControlDistance()) == -1) {
            controlDistance = 32;
        }
        String finalTargetName = targetName;
        Collection matchedPlayers = source.getWorld().getNearbyPlayers(source.getLocation(), (double)controlDistance, p -> {
            if (Objects.equals(p, source)) {
                return false;
            }
            if (NmsRecord.ofPlayer((Player)p).gameMode.getGameModeForPlayer() == GameType.SPECTATOR) {
                return false;
            }
            DisguiseState theirState = this.morphManager().getDisguiseStateFor((Player)p);
            if (theirState != null && theirState.getDisguiseIdentifier().equals("player:" + finalTargetName)) {
                return true;
            }
            return p.getName().equals(finalTargetName) && theirState == null;
        });
        ObjectArrayList list = new ObjectArrayList();
        list.add((Object)source);
        list.addAll(matchedPlayers);
        return list;
    }

    @Override
    public boolean onSwing(Player source) {
        boolean isInChain = this.isInChain(source);
        if (isInChain) {
            return false;
        }
        PlayerTracker tracker = this.tracker();
        if (tracker.droppingItemThisTick(source)) {
            return false;
        }
        PlayerTracker.InteractType lastAction = tracker.getLastInteractAction(source);
        if (!tracker.interactingThisTick(source)) {
            lastAction = PlayerTracker.InteractType.LEFT_CLICK_AIR;
        }
        if (lastAction == null) {
            return false;
        }
        if (source.getGameMode() == GameMode.SPECTATOR && lastAction.isRightClick()) {
            lastAction = PlayerTracker.InteractType.LEFT_CLICK_BLOCK;
        }
        PlayerTracker.InteractType finalLastAction = lastAction;
        this.runIfChainable(source, targetPlayer -> {
            this.simulateOperation(finalLastAction.toBukkitAction(), (Player)targetPlayer, source);
            this.logOperation(source, (Player)targetPlayer, finalLastAction.isLeftClick() ? OperationType.LeftClick : OperationType.RightClick);
        });
        return false;
    }

    @Override
    public boolean onHurtEntity(Player damager, Player hurted) {
        return !this.isInChain(damager) || !this.isInChain(hurted);
    }

    @Override
    public void reset() {
    }
}

