/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.messages;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.platform.CurrentPlatform;
import xyz.nifeather.morph.platform.entity.IPlatformPlayer;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.shaded.pluginbase.Managers.DependencyManager;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class MessageUtils
extends MorphPluginObject {
    private static DependencyManager pluginDepMgr;
    private static MorphConfigManager config;
    private static FeatherMorphMain plugin;
    private static MorphConfigManager configManager;
    private static final Bindable<String> serverLocale;
    private static final Bindable<Boolean> singleLanguage;

    private static void setupConfigManager() {
        if (pluginDepMgr == null) {
            pluginDepMgr = DependencyManager.getInstance(FeatherMorphMain.getMorphNameSpace());
        }
        config = pluginDepMgr.get(MorphConfigManager.class);
        plugin = FeatherMorphMain.getInstance();
    }

    public static Component prefixes(IPlatformPlayer player, Component ... c) {
        return MessageUtils.prefixes((CommandSender)CurrentPlatform.instance().entityLookup().getNativePlayer(player), c);
    }

    public static Component prefixes(CommandSender sender, Component ... c) {
        if (config == null) {
            MessageUtils.setupConfigManager();
        }
        if (!(sender instanceof Player)) {
            return Component.translatable((String)"%s", (ComponentLike[])c);
        }
        TextComponent finalComponent = Component.empty();
        for (Component cc : c) {
            finalComponent = (TextComponent)finalComponent.append(cc);
        }
        FormattableMessage prefix = new FormattableMessage(plugin, config.getOrDefault(String.class, ConfigOption.PLUGIN_PREFIX));
        return prefix.withLocale(MessageUtils.getLocale(sender)).resolve("message", (Component)finalComponent).toComponent(null);
    }

    public static Component prefixes(CommandSender sender, String str) {
        return MessageUtils.prefixes(sender, new Component[]{Component.text((String)str)});
    }

    public static Component prefixes(IPlatformPlayer player, FormattableMessage formattableMessage) {
        return MessageUtils.prefixes((CommandSender)CurrentPlatform.instance().entityLookup().getNativePlayer(player), formattableMessage);
    }

    public static Component prefixes(CommandSender sender, FormattableMessage formattable) {
        if (formattable.getLocale() == null) {
            formattable.withLocale(MessageUtils.getLocale(sender));
        }
        return MessageUtils.prefixes(sender, formattable.toComponent(null));
    }

    @NotNull
    public static String getLocale(IPlatformPlayer player) {
        return MessageUtils.getLocale(CurrentPlatform.instance().entityLookup().getNativePlayer(player));
    }

    @NotNull
    public static String getLocale(Player player) {
        if (MessageUtils.isSingleLanguage()) {
            return MessageUtils.getServerLocale();
        }
        String nmsLocale = NmsRecord.ofPlayer((Player)player).language;
        return nmsLocale == null ? MessageUtils.getServerLocale() : nmsLocale.toLowerCase().replace('-', '_');
    }

    @NotNull
    public static String getLocaleOr(CommandSender sender, @NotNull String defaultValue) {
        String locale = MessageUtils.getLocale(sender);
        return locale == null ? defaultValue : locale;
    }

    private static void initializeConfigManager() {
        if (configManager != null) {
            return;
        }
        DependencyManager depMgr = DependencyManager.getInstance(FeatherMorphMain.getMorphNameSpace());
        MorphConfigManager config = depMgr.get(MorphConfigManager.class);
        if (config != null) {
            config.bind(serverLocale, ConfigOption.LANGUAGE_CODE);
            config.bind(singleLanguage, ConfigOption.SINGLE_LANGUAGE);
        }
        configManager = config;
    }

    public static String getServerLocale() {
        MessageUtils.initializeConfigManager();
        return serverLocale.get();
    }

    public static boolean isSingleLanguage() {
        MessageUtils.initializeConfigManager();
        return singleLanguage.get();
    }

    @Nullable
    public static String getLocale(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!MessageUtils.isSingleLanguage()) {
                return MessageUtils.getLocale(player);
            }
        }
        return MessageUtils.getServerLocale();
    }

    public static String asParsedMiniMessageString(String locale, FormattableMessage formattable) {
        if (formattable.getLocale() == null) {
            formattable.withLocale(locale);
        }
        return (String)MiniMessage.miniMessage().serialize(formattable.toComponent());
    }

    static {
        serverLocale = new Bindable<String>("zh_cn");
        singleLanguage = new Bindable<Boolean>(true);
    }
}

