/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import com.google.gson.annotations.Expose;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.providers.disguise.DisguiseProvider;
import xyz.nifeather.morph.utilities.EntityTypeUtils;

public class DisguiseMeta {
    private final EntityType entityType;
    @NotNull
    public final String rawIdentifier;
    @NotNull
    private final DisguiseTypes disguiseType;
    @Nullable
    private final DisguiseProvider provider;
    @Expose
    public String playerDisguiseTargetName;

    @ApiStatus.Internal
    public EntityType getEntityType() {
        return this.entityType;
    }

    public String getIdentifier() {
        return this.rawIdentifier;
    }

    @Nullable
    public DisguiseProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public DisguiseTypes getDisguiseType() {
        return this.disguiseType;
    }

    public final boolean isPlayerDisguise() {
        return this.disguiseType == DisguiseTypes.PLAYER;
    }

    public DisguiseMeta(@NotNull String rawIdentifier, DisguiseTypes disguiseType) {
        this.rawIdentifier = rawIdentifier;
        this.disguiseType = disguiseType;
        this.provider = MorphManager.getProvider(rawIdentifier);
        switch (disguiseType) {
            case PLAYER: {
                this.entityType = EntityType.PLAYER;
                this.playerDisguiseTargetName = disguiseType.toStrippedId(rawIdentifier);
                break;
            }
            case VANILLA: {
                this.entityType = EntityTypeUtils.fromString(rawIdentifier);
                break;
            }
            default: {
                this.entityType = EntityType.UNKNOWN;
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof DisguiseMeta)) {
            return false;
        }
        DisguiseMeta di = (DisguiseMeta)other;
        return this.equals(di.rawIdentifier);
    }

    public boolean equals(EntityType type) {
        if (!this.isValid()) {
            return false;
        }
        return this.entityType.equals((Object)type);
    }

    public boolean equals(String rawString) {
        return this.rawIdentifier.equals(rawString);
    }

    public boolean isValid() {
        return this.disguiseType != DisguiseTypes.UNKNOWN;
    }

    public String getKey() {
        return this.rawIdentifier;
    }

    @Deprecated
    public Component asComponent() {
        return this.isValid() ? (this.provider == null ? Component.text((String)this.rawIdentifier) : this.provider.getDisplayName(this.rawIdentifier, null)) : Component.text((String)this.rawIdentifier);
    }

    public Component asComponent(String locale) {
        return this.isValid() ? (this.provider == null ? Component.text((String)this.rawIdentifier) : this.provider.getDisplayName(this.rawIdentifier, locale)) : Component.text((String)this.rawIdentifier);
    }

    public int objectHashCode() {
        return super.hashCode();
    }

    public int hashCode() {
        return this.rawIdentifier.hashCode();
    }

    public String toString() {
        return "DisguiseMeta[Type=" + String.valueOf(this.entityType) + ", DisguiseType=" + String.valueOf((Object)this.getDisguiseType()) + ", targetPlayerName=" + this.playerDisguiseTargetName + "]";
    }
}

