/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import java.util.Arrays;
import java.util.Optional;
import org.bukkit.NamespacedKey;

public enum DisguiseTypes {
    VANILLA("minecraft"),
    ITEM_DISPLAY("item_display"),
    BLOCK_DISPLAY("block_display"),
    PLAYER("player"),
    LD("local"),
    EXTERNAL("external"),
    MODEL_ENGINE("model4"),
    UNKNOWN("unknown");

    private final String nameSpace;

    private DisguiseTypes(String namespace) {
        this.nameSpace = namespace;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public static DisguiseTypes fromNameSpace(String namespace) {
        DisguiseTypes[] types = DisguiseTypes.values();
        Optional<DisguiseTypes> optional = Arrays.stream(types).filter(t -> t.getNameSpace().equals(namespace)).findFirst();
        return optional.orElse(UNKNOWN);
    }

    public static DisguiseTypes fromId(String id) {
        if (id.equals("minecrcaft:player")) {
            return EXTERNAL;
        }
        String str = id + ":";
        String[] idSplited = str.split(":", 3);
        DisguiseTypes result = DisguiseTypes.fromNameSpace(idSplited[0]);
        if (result == UNKNOWN) {
            result = EXTERNAL;
        }
        return result;
    }

    public static DisguiseTypes fromId(NamespacedKey key) {
        return DisguiseTypes.fromId(key.asString());
    }

    public String toId(String id) {
        return this.getNameSpace() + ":" + id;
    }

    public NamespacedKey toNamespacedKey(String id) {
        return NamespacedKey.fromString((String)this.toId(id));
    }

    public String toStrippedId(String rawString) {
        return rawString.replace(this.getNameSpace() + ":", "");
    }
}

