/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class ExecutionErrorException
extends Exception {
    public final Optional<FormattableMessage> localizableMessage;
    public final String methodName;

    public ExecutionErrorException(String methodName, String msg) {
        this(methodName, msg, null);
    }

    public ExecutionErrorException(String methodName, String msg, Throwable cause) {
        this(methodName, msg, cause, null);
    }

    public ExecutionErrorException(String methodName, String msg, Throwable cause, @Nullable FormattableMessage localizableMessage) {
        super(msg, cause);
        this.localizableMessage = Optional.ofNullable(localizableMessage);
        this.methodName = methodName == null ? "" : methodName;
    }

    public static ExecutionErrorGenerator forMethod(String method) {
        return new ExecutionErrorGenerator(method);
    }

    public static class ExecutionErrorGenerator {
        public String exceptionMessage = "unknown error (reason not given)";
        public String methodName = "";
        @Nullable
        public Throwable cause;
        @Nullable
        public FormattableMessage localizableMessage;

        public ExecutionErrorGenerator(String methodName) {
            this.methodName = methodName;
        }

        public ExecutionErrorGenerator withMessage(String msg) {
            this.exceptionMessage = msg;
            return this;
        }

        public ExecutionErrorGenerator causedBy(Throwable throwable) {
            this.cause = throwable;
            return this;
        }

        public ExecutionErrorGenerator withLocalizableMessage(FormattableMessage formattableMessage) {
            this.localizableMessage = formattableMessage;
            return this;
        }

        public ExecutionErrorException create() {
            String finalExceptionMessage = this.methodName.isBlank() ? this.exceptionMessage : "%s: %s".formatted(this.methodName, this.exceptionMessage);
            return new ExecutionErrorException(this.methodName, finalExceptionMessage, this.cause, this.localizableMessage);
        }
    }
}

