/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.api.FeatherMorphAPI;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandle;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandle;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;

public abstract class AbstractProperties<E extends Entity> {
    protected final Logger logger = FeatherMorphMain.getInstance().getSLF4JLogger();
    protected final Map<String, SingleProperty<?>> values = new ConcurrentHashMap();

    protected <X> SingleProperty<X> createProperty(String name, X val, InputHandle<X> inputHandle, OutputHandle<X> outputHandle) {
        if (val == null) {
            throw new IllegalArgumentException("May not pass a null value to getSingle()");
        }
        return SingleProperty.of(name, val, inputHandle, outputHandle);
    }

    protected void registerSingle(SingleProperty<?> ... value) {
        for (SingleProperty<?> property : value) {
            this.registerSingle(property);
        }
    }

    protected void registerSingle(SingleProperty<?> value) {
        SingleProperty duplicateValue = this.values.getOrDefault(value.id(), null);
        if (duplicateValue != null) {
            throw new IllegalArgumentException("Already contains a value with ID '%s'".formatted(value.id()));
        }
        this.values.put(value.id(), value);
    }

    @Deprecated
    public List<SingleProperty<?>> getValues() {
        return new ObjectArrayList(this.values.values());
    }

    public Map<String, SingleProperty<?>> getRegisteredProperties() {
        return Map.copyOf(this.values);
    }

    public final Map<SingleProperty<?>, Object> readFromPropertiesInput(Map<String, String> propertiesInput) throws ParseErrorException {
        ConcurrentHashMap map = new ConcurrentHashMap();
        for (Map.Entry<String, String> entry : propertiesInput.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            SingleProperty property = this.values.getOrDefault(key, null);
            if (property == null) continue;
            property.forInput(value).ifPresent(o -> map.put(property, o));
        }
        return map;
    }

    @Nullable
    protected abstract E tryCastEntity(@Nullable Entity var1);

    protected boolean validateOtherDisguise(DisguiseState our, DisguiseState other) {
        return our.disguisePropertyHandler().bindingPropertiesEquals(other.disguisePropertyHandler());
    }

    public final void setupProperties(DisguiseState state, @Nullable Entity targetEntity) {
        DisguiseState theirDisguise = Objects.requireNonNull(FeatherMorphAPI.instance()).directAccess().morphManager().getDisguiseStateFor(targetEntity);
        if (theirDisguise != null) {
            if (this.validateOtherDisguise(state, theirDisguise)) {
                this.setupFromOtherDisguise(state, theirDisguise);
            }
            return;
        }
        E cast = this.tryCastEntity(targetEntity);
        if (cast != null) {
            this.setupPropertiesFromEntity(state.disguisePropertyHandler(), cast);
        } else {
            this.setupDefaultProperties(state.disguisePropertyHandler());
        }
    }

    protected abstract void setupPropertiesFromEntity(PropertyHandler var1, @NotNull E var2);

    protected abstract void setupDefaultProperties(PropertyHandler var1);

    protected void setupFromOtherDisguise(DisguiseState ourState, DisguiseState theirState) {
        PropertyHandler ourHandler = ourState.disguisePropertyHandler();
        PropertyHandler theirHandler = theirState.disguisePropertyHandler();
        theirHandler.copyTo(ourHandler);
    }

    public final Map<String, String> mapToNetworkProperties(PropertyHandler propertyHandler) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        try {
            for (SingleProperty<?> p : this.values.values()) {
                SingleProperty<?> property = p;
                Optional<?> optional = propertyHandler.getOptional(property);
                if (!optional.isPresent()) continue;
                map.put(property.id(), property.forValue(optional.get()));
            }
        }
        catch (ParseErrorException e) {
            this.logger.error("Failed writing values", (Throwable)e);
        }
        return map;
    }
}

