/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.gui;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.shaded.inventorygui.InventoryGui;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.shaded.pluginbase.ScheduleInfo;

public class ScreenWrapper
extends MorphPluginObject {
    protected Bindable<Boolean> isDynamic = new Bindable<Boolean>(false);
    private final Player bindingPlayer;
    protected final String playerLocale;
    public static final Sound clickSound = (Sound)Sound.sound().type(Key.key((String)"ui.button.click")).volume(0.45f).build();
    public static final Sound openSound = (Sound)Sound.sound().type(Key.key((String)"entity.experience_orb.pickup")).volume(0.55f).build();
    protected static final MiniMessage defaultMiniMessage = MiniMessage.miniMessage();
    protected InventoryGui guiInstance;
    private ScheduleInfo updateScheduleInfo;

    protected Player getBindingPlayer() {
        return this.bindingPlayer;
    }

    public ScreenWrapper(Player bindingPlayer) {
        this.bindingPlayer = bindingPlayer;
        this.playerLocale = MessageUtils.getLocale(bindingPlayer);
        this.isDynamic.onValueChanged((o, n) -> {
            if (n.booleanValue() && this.isCurrent()) {
                this.updateScheduleInfo = this.addSchedule(this::update);
            } else if (this.updateScheduleInfo != null) {
                this.updateScheduleInfo.cancel();
            }
        });
    }

    protected boolean isCurrent() {
        if (this.guiInstance == null) {
            return false;
        }
        return this.guiInstance.equals(InventoryGui.getOpen((HumanEntity)this.bindingPlayer));
    }

    protected void onUpdate() {
    }

    private void update() {
        if (this.plugin.getCurrentTick() % 10L != 0L && this.isDynamic.get().booleanValue()) {
            this.addSchedule(this::update);
            return;
        }
        if (!this.isCurrent()) {
            return;
        }
        this.onUpdate();
        this.addSchedule(this::update);
        this.guiInstance.draw((HumanEntity)this.bindingPlayer);
    }

    public void show() {
        if (this.guiInstance == null) {
            this.logger.error("Attempting to show a null GUI to the player! No continuing...");
            return;
        }
        this.guiInstance.show((HumanEntity)this.bindingPlayer);
        if (this.isDynamic.get().booleanValue()) {
            this.updateScheduleInfo = this.addSchedule(this::update);
        }
    }
}

