/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal.impl;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.craftbukkit.entity.CraftMob;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.utilities.EntityTypeUtils;

public class MorphNearestAttackableGoal
implements Goal<org.bukkit.entity.Mob> {
    private final org.bukkit.entity.Mob mob;
    private final MorphManager morphManager;
    @Nullable
    private LivingEntity targetedEntity;
    @Nullable
    private DisguiseState cachedTargetEntityState;

    public MorphNearestAttackableGoal(org.bukkit.entity.Mob mob, MorphManager morphManager) {
        this.mob = mob;
        this.morphManager = morphManager;
    }

    public boolean shouldActivate() {
        LivingEntity newTarget;
        Tameable tameable;
        org.bukkit.entity.Mob mob = this.mob;
        if (mob instanceof Tameable && (tameable = (Tameable)mob).isTamed()) {
            return false;
        }
        if (this.targetedEntity != null) {
            return this.checkTargetEntity();
        }
        if (ThreadLocalRandom.current().nextInt(10) != 0) {
            return false;
        }
        this.targetedEntity = newTarget = this.findTarget();
        return newTarget != null;
    }

    private boolean checkTargetEntity() {
        LivingEntity target = this.targetedEntity;
        if (target == null) {
            return false;
        }
        boolean cancelTarget = !this.mob.getWorld().equals((Object)target.getWorld());
        boolean bl = cancelTarget = cancelTarget || target.getLocation().distance(this.mob.getLocation()) > this.getFollowRange();
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            GameMode gamemode = targetPlayer.getGameMode();
            cancelTarget = cancelTarget || !targetPlayer.isOnline();
            cancelTarget = cancelTarget || gamemode.isInvulnerable();
            DisguiseState state = this.cachedTargetEntityState;
            cancelTarget = state != null && !state.disposed() ? cancelTarget || EntityTypeUtils.panicsFrom(this.mob.getType(), state.getEntityType()) : true;
        }
        return !cancelTarget;
    }

    private double getFollowRange() {
        AttributeInstance followRangeAttribute = this.mob.getAttribute(Attribute.FOLLOW_RANGE);
        return followRangeAttribute == null ? 16.0 : followRangeAttribute.getValue();
    }

    private LivingEntity findTarget() {
        double followRange = this.getFollowRange();
        List<Player> players = this.mob.getNearbyEntities(followRange, followRange, followRange).stream().filter(e -> {
            if (!(e instanceof Player)) {
                return false;
            }
            Player player = (Player)e;
            GameMode gamemode = player.getGameMode();
            return gamemode == GameMode.SURVIVAL || gamemode == GameMode.ADVENTURE;
        }).map(e -> (Player)e).toList();
        for (Player candidate : players) {
            DisguiseState state = this.morphManager.getDisguiseStateFor(candidate);
            if (state == null || !EntityTypeUtils.hostiles(this.mob.getType(), state.getEntityType())) continue;
            this.cachedTargetEntityState = state;
            return candidate;
        }
        return null;
    }

    public void start() {
        this.mob.setTarget(this.targetedEntity);
    }

    public void stop() {
        Mob mobHandle;
        LivingEntity target = this.targetedEntity;
        if (target == null) {
            return;
        }
        if (target.equals((Object)this.mob.getTarget())) {
            this.mob.setTarget(null);
        }
        if ((mobHandle = ((CraftMob)this.mob).getHandle()) instanceof NeutralMob) {
            NeutralMob neutralMob = (NeutralMob)mobHandle;
            neutralMob.stopBeingAngry();
        }
        this.targetedEntity = null;
        this.cachedTargetEntityState = null;
    }

    @NotNull
    public @NotNull GoalKey<@NotNull org.bukkit.entity.Mob> getKey() {
        return GoalKey.of(org.bukkit.entity.Mob.class, (NamespacedKey)Objects.requireNonNull(NamespacedKey.fromString((String)"feathermorph:nearest_attackable_goal")));
    }

    @NotNull
    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.TARGET);
    }
}

