/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.multiInstance.protocol;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.network.multiInstance.protocol.c2s.MIC2SCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CCommand;

public class CommandRegistriesCopy {
    private final Object2ObjectArrayMap<String, Function<Map<String, String>, MIC2SCommand>> c2sCmds = new Object2ObjectArrayMap();
    private final Object2ObjectArrayMap<String, Function<Map<String, String>, MIS2CCommand>> s2cCmds = new Object2ObjectArrayMap();

    public CommandRegistriesCopy registerC2S(String name, Function<Map<String, String>, MIC2SCommand> function) {
        this.c2sCmds.put((Object)name, function);
        return this;
    }

    public CommandRegistriesCopy registerS2C(String name, Function<Map<String, String>, MIS2CCommand> function) {
        this.s2cCmds.put((Object)name, function);
        return this;
    }

    @NotNull
    public MIS2CCommand createS2CCommand(String baseName, Map<String, String> args) throws RuntimeException {
        Function func = (Function)this.s2cCmds.getOrDefault((Object)baseName, null);
        return (MIS2CCommand)Objects.requireNonNull(func, "No Func found for command name '%s'".formatted(baseName)).apply(args);
    }

    @NotNull
    public MIC2SCommand createC2SCommand(String baseName, Map<String, String> args) throws RuntimeException {
        Function func = (Function)this.c2sCmds.getOrDefault((Object)baseName, null);
        return (MIC2SCommand)Objects.requireNonNull(func, "No Func found for command name '%s'".formatted(baseName)).apply(args);
    }
}

