/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.server.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.fmccl.converter.C2SCommandConverter;
import xyz.nifeather.fmccl.converter.S2CCommandConverter;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SCommand;
import xyz.nifeather.fmccl.processor.C2SCommandProcessor;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SCommandRecord;
import xyz.nifeather.morph.network.commands.C2S.ClientInitializeRecordV3;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.InitializeRespondV3;
import xyz.nifeather.morph.network.server.MessageChannel;
import xyz.nifeather.morph.network.server.handlers.AbstractCommandPacketHandler;
import xyz.nifeather.morph.network.server.handlers.MorphLegacyCommandConverter;
import xyz.nifeather.morph.network.server.handlers.results.CommandHandleResult;
import xyz.nifeather.morph.network.server.handlers.results.VersionHandleResult;

public class V2ProtocolHandler
extends AbstractCommandPacketHandler {
    public static final V2ProtocolHandler V2_INSTANCE = new V2ProtocolHandler();
    private final C2SCommandProcessor commandProcessor = new C2SCommandProcessor();
    private final S2CCommandConverter s2cConverter = new MorphLegacyCommandConverter();
    private final C2SCommandConverter c2sConverter = new C2SCommandConverter();
    private static final List<String> validChannels = List.of(MessageChannel.initializeChannelV1, MessageChannel.versionChannelV2, MessageChannel.commandChannelV2);

    @Override
    @NotNull
    public List<String> validChannels() {
        return validChannels;
    }

    @Override
    @NotNull
    public ClientInitializeRecordV3 handleInitializeData(Player player, byte @NotNull [] rawData) {
        ObjectArrayList content;
        try {
            String stringContent = this.readStringFromByteInput(rawData);
            if (stringContent.isBlank()) {
                if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                    this.logger.info("Input string is blank, assuming the player is using V1...");
                }
                return ClientInitializeRecordV3.fail();
            }
            List<String> contentList = Arrays.stream(stringContent.split(" ")).toList();
            content = new ObjectArrayList(contentList);
        }
        catch (Throwable t) {
            if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                this.logger.info("'%s' is possibly using a legacy client.".formatted(player.getName()));
            }
            if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                this.logger.info("Unable to decode packet. Is '%s' using a legacy client? %s".formatted(player.getName()), t);
            }
            return ClientInitializeRecordV3.fail();
        }
        return new ClientInitializeRecordV3((List<String>)content, 0, true);
    }

    public void sendV2InitalizeRespond(Player player, List<String> featureFlags) {
        StringBuilder featureFlagsMessageBuilder = new StringBuilder();
        Iterator<String> it = featureFlags.iterator();
        while (it.hasNext()) {
            String next = it.next();
            featureFlagsMessageBuilder.append(next);
            if (!it.hasNext()) continue;
            featureFlagsMessageBuilder.append(" ");
        }
        this.sendString(player, MessageChannel.initializeChannelV1, featureFlagsMessageBuilder.toString());
    }

    @Override
    public void sendInitializeRespond(Player player, InitializeRespondV3 respond) {
        this.sendInt(player, MessageChannel.versionChannelV2, respond.apiVersion());
    }

    @Override
    @NotNull
    public VersionHandleResult handleVersionData(@NotNull Player player, byte @NotNull [] data) {
        try {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
            int clientVersion = buf.readInt();
            return VersionHandleResult.from(clientVersion);
        }
        catch (Throwable t) {
            this.logger.warn("Failed to handle version input from '%s', they might using legacy client implementation: %s".formatted(player.getName(), t.getMessage()));
            return VersionHandleResult.fail();
        }
    }

    @Override
    @NotNull
    public CommandHandleResult handleCommandData(@NotNull Player player, byte @NotNull [] data) {
        try {
            String str = this.readStringFromByteInput(data);
            NetheriteC2SCommand<?> command = this.commandProcessor.processLegacyCommandLine(str);
            AbstractC2SCommand<?> convert = this.c2sConverter.fromNetheriteCommand(command);
            return CommandHandleResult.from(C2SCommandRecord.fromC2SCommand(convert));
        }
        catch (Throwable t) {
            this.logger.error("Failed to handle command from player '%s': %s".formatted(player.getName(), t.getMessage()));
            return CommandHandleResult.fail();
        }
    }

    @Override
    public void sendCommand(Player player, AbstractS2CCommand<?> command) {
        String commandString;
        try {
            commandString = this.s2cConverter.toNetheriteCommand(command).buildCommand();
        }
        catch (Throwable t) {
            if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                this.logger.warn("Can't convert from modern to legacy: " + t.getMessage());
            }
            return;
        }
        this.sendString(player, MessageChannel.commandChannelV2, commandString);
    }

    public void sendString(Player player, String channel, String message) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer()).writeUtf(message);
        this.sendPacketRaw(channel, player, (ByteBuf)buffer);
    }

    protected String readStringFromByteInput(byte[] rawData) throws Throwable {
        String input = null;
        try {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])rawData));
            input = buf.readUtf();
            if (buf.readableBytes() > 0) {
                throw new RuntimeException("Malformed buffer: still has %s readable bytes!".formatted(buf.readableBytes()));
            }
        }
        catch (Throwable t) {
            this.logger.info("Failed to decode byte: %s".formatted(t.getMessage()));
            throw t;
        }
        return input;
    }
}

