/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.shaded.pluginbase.Managers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.DependencyAlreadyRegistedException;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;
import xyz.nifeather.morph.shaded.pluginbase.XiaMoJavaPlugin;

public class DependencyManager {
    private static final Map<String, DependencyManager> instances = new ConcurrentHashMap<String, DependencyManager>();
    private final Map<Class<?>, Object> registers = new ConcurrentHashMap();

    @Deprecated
    public static DependencyManager GetInstance(String namespace) {
        return DependencyManager.getInstance(namespace);
    }

    public static DependencyManager getInstance(String namespace) {
        return instances.get(namespace);
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static DependencyManager getManagerOrCreate(XiaMoJavaPlugin pluginInstance) {
        if (pluginInstance == null) {
            return null;
        }
        DependencyManager depMgr = instances.get(pluginInstance.getNamespace());
        if (depMgr != null) {
            return depMgr;
        }
        depMgr = new DependencyManager(pluginInstance);
        return depMgr;
    }

    @Deprecated
    public DependencyManager(XiaMoJavaPlugin plugin) {
        this.registerPluginInstance(plugin);
    }

    public void registerPluginInstance(XiaMoJavaPlugin plugin) {
        if (instances.containsKey(plugin.getNamespace())) {
            LoggerFactory.getLogger((String)"XiaMoBase").warn("\u5df2\u7ecf\u6709\u4e00\u4e2a " + plugin.getNamespace() + "\u7684DependencyManager\u5b9e\u4f8b\u4e86");
            Thread.dumpStack();
        }
        instances.put(plugin.getNamespace(), this);
    }

    public void unRegisterPluginInstance(XiaMoJavaPlugin plugin) {
        instances.remove(plugin.getNamespace());
    }

    @Deprecated
    public void Cache(Object obj) throws DependencyAlreadyRegistedException {
        this.cache(obj);
    }

    public void cache(Object obj) throws DependencyAlreadyRegistedException {
        this.cacheAs(obj.getClass(), obj);
    }

    @Deprecated
    public void CacheAs(Class<?> classType, Object obj) throws DependencyAlreadyRegistedException {
        this.cacheAs(classType, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheAs(Class<?> classType, Object obj) throws DependencyAlreadyRegistedException {
        Map<Class<?>, Object> map = this.registers;
        synchronized (map) {
            if (!classType.isInstance(obj)) {
                throw new IllegalArgumentException(String.valueOf(obj) + "\u4e0d\u80fd\u6ce8\u518c\u4e3a" + String.valueOf(classType));
            }
            if (this.registers.containsKey(classType)) {
                throw new DependencyAlreadyRegistedException("\u5df2\u7ecf\u6ce8\u518c\u8fc7\u4e00\u4e2a" + classType.getSimpleName() + "\u7684\u4f9d\u8d56\u4e86");
            }
            this.registers.put(classType, obj);
        }
    }

    @Deprecated
    public boolean UnCache(Object obj) {
        return this.unCache(obj);
    }

    public boolean unCache(Object obj) {
        if (!this.registers.containsValue(obj)) {
            return false;
        }
        this.registers.remove(obj.getClass(), obj);
        return true;
    }

    @Deprecated
    public void UnCacheAll() {
        this.unCacheAll();
    }

    public void unCacheAll() {
        this.registers.clear();
    }

    @Deprecated
    public <T> T Get(Class<T> classType) {
        return this.get(classType);
    }

    @Deprecated
    public <T> T Get(Class<T> classType, boolean throwOnNotFound) {
        return this.get(classType, throwOnNotFound);
    }

    public <T> T get(Class<T> classType) {
        return this.get(classType, true);
    }

    @Nullable
    public <T> T get(Class<T> classType, boolean throwOnNotFound) {
        if (this.registers.containsKey(classType)) {
            return (T)this.registers.get(classType);
        }
        if (throwOnNotFound) {
            throw new NullDependencyException("\u4f9d\u8d56\u7684\u5bf9\u8c61\uff08" + String.valueOf(classType) + "\uff09\u672a\u627e\u5230");
        }
        return null;
    }
}

